/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.logging.SourceLog;
import net.mapeadores.util.logging.SourceLogBuilder;
import net.mapeadores.util.logging.SourceLogs;

public class SourceLogsBuilder
implements MultiMessageHandler {
    private final Map<String, SourceLogBuilder> builderMap = new LinkedHashMap<String, SourceLogBuilder>();
    private SourceLogBuilder currentBuffer = null;

    @Override
    public void setCurrentSource(String sourceName) {
        SourceLogBuilder builder = this.builderMap.get(sourceName);
        if (builder == null) {
            builder = new SourceLogBuilder(sourceName);
            this.builderMap.put(sourceName, builder);
        }
        this.currentBuffer = builder;
    }

    @Override
    public void addMessage(String category, Message message) {
        if (this.currentBuffer == null) {
            this.setCurrentSource("");
        }
        this.currentBuffer.addMessage(category, message);
    }

    public SourceLogs toSourceLogs() {
        ArrayList<SourceLog> tempList = new ArrayList<SourceLog>();
        for (SourceLogBuilder builder : this.builderMap.values()) {
            SourceLog log = builder.toSourceLog();
            if (log.isEmpty()) continue;
            tempList.add(log);
        }
        return new InternalSourceLogs(tempList.toArray(new SourceLog[tempList.size()]));
    }

    private static class InternalSourceLogs
    extends AbstractList<SourceLog>
    implements SourceLogs {
        private final SourceLog[] array;

        private InternalSourceLogs(SourceLog[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SourceLog get(int i) {
            return this.array[i];
        }
    }
}

