/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.SourceLogs;

public class CommandMessageBuilder {
    private List<Message> multiErrorList;
    private SourceLogs commandLogs;
    private Message mainMessage;
    private boolean isError;

    public CommandMessageBuilder setError(String messageKey, Object ... messageValues) {
        this.mainMessage = LocalisationUtils.toMessage(messageKey, messageValues);
        this.isError = true;
        return this;
    }

    public CommandMessageBuilder setError(Message message) {
        this.mainMessage = message;
        this.isError = true;
        return this;
    }

    public CommandMessageBuilder setDone(String messageKey, Object ... messageValues) {
        this.mainMessage = LocalisationUtils.toMessage(messageKey, messageValues);
        this.isError = false;
        return this;
    }

    public CommandMessageBuilder setDone(Message message) {
        this.mainMessage = message;
        this.isError = false;
        return this;
    }

    public CommandMessageBuilder addMultiError(Message message) {
        if (this.multiErrorList == null) {
            this.multiErrorList = new ArrayList<Message>();
        }
        this.multiErrorList.add(message);
        return this;
    }

    public CommandMessageBuilder addMultiError(String messageKey, Object ... messageValues) {
        if (this.multiErrorList == null) {
            this.multiErrorList = new ArrayList<Message>();
        }
        this.multiErrorList.add(LocalisationUtils.toMessage(messageKey, messageValues));
        return this;
    }

    public CommandMessageBuilder setCommandLogs(SourceLogs commandLogs) {
        this.commandLogs = commandLogs;
        return this;
    }

    public boolean hasMultiError() {
        return this.multiErrorList != null;
    }

    public CommandMessage toCommandMessage() {
        Message finalMainMessage;
        if (this.mainMessage != null) {
            finalMainMessage = this.mainMessage;
        } else if (this.multiErrorList != null) {
            finalMainMessage = this.multiErrorList.get(0);
            this.isError = true;
        } else {
            throw new IllegalStateException("mainMessage is not defined");
        }
        List<Message> finalList = this.multiErrorList == null ? LogUtils.EMPTY_MESSAGELIST : this.multiErrorList;
        return new InternalCommandMessage(finalMainMessage, this.isError, finalList, this.commandLogs);
    }

    public static CommandMessageBuilder init() {
        return new CommandMessageBuilder();
    }

    private static class InternalCommandMessage
    implements CommandMessage {
        private final Message mainMessage;
        private final boolean isError;
        private final List<Message> errorList;
        private final SourceLogs commandLogs;

        private InternalCommandMessage(Message mainMessage, boolean isError, List<Message> errorList, SourceLogs commandLogs) {
            this.mainMessage = mainMessage;
            this.isError = isError;
            this.errorList = errorList;
            this.commandLogs = commandLogs;
        }

        @Override
        public String getMessageKey() {
            return this.mainMessage.getMessageKey();
        }

        @Override
        public Object[] getMessageValues() {
            return this.mainMessage.getMessageValues();
        }

        @Override
        public boolean isErrorMessage() {
            return this.isError;
        }

        @Override
        public List<Message> getMultiErrorList() {
            return this.errorList;
        }

        @Override
        public SourceLogs getCommandLogs() {
            return this.commandLogs;
        }
    }
}

