/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import java.text.ParseException;
import java.util.Locale;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.LangPreference;

public interface UserLangContext
extends LangContext {
    public Lang getWorkingLang();

    public LangPreference getLangPreference();

    public Locale getFormatLocale();

    @Override
    default public Lang getDefaultLang() {
        return this.getWorkingLang();
    }

    @Override
    default public Locale getDefaultFormatLocale() {
        return this.getFormatLocale();
    }

    default public boolean isDefaultLocale() {
        try {
            return Lang.fromLocale(this.getFormatLocale()).equals(this.getWorkingLang());
        }
        catch (ParseException pe) {
            return false;
        }
    }

    default public boolean isDefaultLangPreference() {
        LangPreference langPreference = this.getLangPreference();
        return langPreference.size() == 1 && ((Lang)langPreference.get(0)).equals(this.getWorkingLang());
    }

    default public String getISOFormatLocaleString() {
        return Lang.toISOString(this.getFormatLocale());
    }
}

