/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.lexie.LexieFilter;

public class LocalisationLexieFilters {
    static final DefaultWordFilter defaultWordFilter = new DefaultWordFilter();
    static final Map<Lang, LexieFilter> currentFilter = new HashMap<Lang, LexieFilter>();

    private LocalisationLexieFilters() {
    }

    public static LexieFilter getLexieFilter(Lang lang) {
        LexieFilter wordFilter = currentFilter.get(lang);
        if (wordFilter == null) {
            wordFilter = LocalisationLexieFilters.init(lang);
            currentFilter.put(lang, wordFilter);
        }
        return wordFilter;
    }

    private static LexieFilter init(Lang lang) {
        Class<LocalisationLexieFilters> currentClass = LocalisationLexieFilters.class;
        String langString = lang.toString();
        InputStream propertiesStream = currentClass.getResourceAsStream("resources/wordfilter_" + langString + ".properties");
        InputStream forbiddenStream = currentClass.getResourceAsStream("resources/forbiddenwords_" + langString + ".txt");
        try {
            LexieFilter wordFilter = LocalisationLexieFilters.init(lang, propertiesStream, forbiddenStream);
            if (wordFilter == null) {
                wordFilter = defaultWordFilter;
            }
            return wordFilter;
        }
        catch (IOException ioe) {
            return defaultWordFilter;
        }
    }

    private static LexieFilter init(Lang lang, InputStream propertiesStream, InputStream forbiddenStream) throws IOException {
        String ligne;
        if (propertiesStream == null) {
            return null;
        }
        if (forbiddenStream == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.load(propertiesStream);
        propertiesStream.close();
        ArrayList<String> forbiddenList = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(forbiddenStream, "UTF-8"));
        while ((ligne = reader.readLine()) != null) {
            if ((ligne = ligne.trim()).length() <= 0 || ligne.charAt(0) == '#') continue;
            forbiddenList.add(ligne);
        }
        reader.close();
        LocalisationWordFilter wordFilter = new LocalisationWordFilter(lang, properties, forbiddenList);
        return wordFilter;
    }

    private static class DefaultWordFilter
    implements LexieFilter {
        private DefaultWordFilter() {
        }

        @Override
        public boolean acceptLexie(String word) {
            switch (word.length()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return Character.isIdeographic(word.charAt(0));
                }
                case 2: {
                    return false;
                }
            }
            return true;
        }
    }

    private static class LocalisationWordFilter
    implements LexieFilter {
        private final Locale locale;
        private final Set<String> forbiddenWordSet;
        private int minlength = 3;
        private int minpartlength = 2;
        private int maxForbiddenWordLength = 0;

        private LocalisationWordFilter(Lang lang, Properties properties, List<String> forbiddenList) {
            String minpartlengthString;
            String minlengthString = properties.getProperty("minlength");
            if (minlengthString != null) {
                try {
                    this.minlength = Integer.parseInt(minlengthString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((minpartlengthString = properties.getProperty("minpartlength")) != null) {
                try {
                    this.minpartlength = Integer.parseInt(minpartlengthString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.locale = lang.toLocale();
            if (forbiddenList.size() > 0) {
                this.forbiddenWordSet = new HashSet<String>();
                for (String s : forbiddenList) {
                    s = s.toLowerCase(this.locale);
                    this.forbiddenWordSet.add(s);
                    this.maxForbiddenWordLength = Math.max(this.maxForbiddenWordLength, s.length());
                }
            } else {
                this.forbiddenWordSet = null;
            }
        }

        @Override
        public boolean acceptLexie(String word) {
            int length = word.length();
            if (length == 1 && Character.isIdeographic(word.charAt(0))) {
                return true;
            }
            if (length < this.minlength) {
                if (length > 1) {
                    try {
                        Integer.parseInt(word);
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return false;
            }
            if (length > this.maxForbiddenWordLength) {
                return true;
            }
            if (this.forbiddenWordSet == null) {
                return true;
            }
            return !this.forbiddenWordSet.contains(word.toLowerCase(this.locale));
        }
    }
}

