/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import java.util.AbstractList;
import java.util.LinkedHashSet;
import java.util.Set;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.Langs;

public class LangPreferenceBuilder {
    private final Set<Lang> langSet = new LinkedHashSet<Lang>();

    public boolean isEmpty() {
        return this.langSet.isEmpty();
    }

    public LangPreferenceBuilder addLang(Lang lang) {
        if (lang == null) {
            throw new IllegalArgumentException("lang is null");
        }
        this.langSet.add(lang);
        return this;
    }

    public LangPreferenceBuilder addLangs(Langs langs) {
        int size = langs.size();
        for (int i = 0; i < size; ++i) {
            this.langSet.add((Lang)langs.get(i));
        }
        return this;
    }

    public LangPreference toLangPreference() {
        int size = this.langSet.size();
        if (size == 0) {
            throw new IllegalStateException("No lang defined");
        }
        return new InternalLangPreference(this.langSet.toArray(new Lang[size]));
    }

    public static LangPreferenceBuilder init() {
        return new LangPreferenceBuilder();
    }

    private static class InternalLangPreference
    extends AbstractList<Lang>
    implements LangPreference {
        private final Lang[] langArray;

        private InternalLangPreference(Lang[] langArray) {
            this.langArray = langArray;
        }

        @Override
        public int size() {
            return this.langArray.length;
        }

        @Override
        public Lang get(int index) {
            return this.langArray[index];
        }

        @Override
        public Lang getFirstLang() {
            return this.langArray[0];
        }
    }
}

