/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.instruction;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionErrorHandler;
import net.mapeadores.util.text.StringUtils;

public final class InstructionUtils {
    public static final InstructionErrorHandler DEFAULT_ERROR_HANDLER = new DefaultInstructionErrorHandler();
    public static final Map<String, Object> EMPTY_OPTIONS = Collections.emptyMap();

    private InstructionUtils() {
    }

    public static Argument toArgument(String key, String value) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("key is null or empty");
        }
        if (value != null && value.length() == 0) {
            value = null;
        }
        return new InternalArgument(key, value);
    }

    public static Instruction toInstruction(Collection<Argument> col) {
        int size = col.size();
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        return new InternalInstruction(col.toArray(new Argument[size]));
    }

    public static void appendInstructionString(String s, Appendable buf) throws IOException {
        int length = s.length();
        if (length == 0) {
            buf.append("\"\"");
        } else if (StringUtils.isValidAsciiString(s)) {
            buf.append(s);
        } else {
            buf.append('\"');
            block7: for (int i = 0; i < length; ++i) {
                char carac = s.charAt(i);
                switch (carac) {
                    case '\"': {
                        buf.append("\\\"");
                        continue block7;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block7;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block7;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block7;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block7;
                    }
                    default: {
                        buf.append(carac);
                    }
                }
            }
            buf.append('\"');
        }
    }

    private static class InternalArgument
    implements Argument {
        private final String key;
        private final String value;

        private InternalArgument(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    private static class InternalInstruction
    extends AbstractList<Argument>
    implements Instruction {
        private final Argument[] array;

        private InternalInstruction(Argument[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Argument get(int i) {
            return this.array[i];
        }
    }

    public static class DefaultInstructionErrorHandler
    implements InstructionErrorHandler {
        private DefaultInstructionErrorHandler() {
        }

        @Override
        public void invalidAsciiCharacterError(String part, int row, int col) {
        }

        @Override
        public void invalidEndCharacterError(String part, int row, int col) {
        }

        @Override
        public void invalidSeparatorCharacterError(String part, int row, int col) {
        }
    }
}

