/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.mapeadores.util.http.RedirectionUrl;
import net.mapeadores.util.http.UrlStatus;
import net.mapeadores.util.http.UrlStatusUtils;

public final class UrlTestEngine {
    private static final int LIMIT = 10;
    private static final int TIMEOUT = 1000;

    public static UrlStatus test(String urlString) {
        Object firstTest = UrlTestEngine.testUrl(null, urlString);
        if (firstTest instanceof UrlStatus) {
            return (UrlStatus)firstTest;
        }
        return UrlTestEngine.testConnection((URL)firstTest, 0);
    }

    private static Object testUrl(URL context, String urlString) {
        try {
            URL url = context != null ? new URL(context, urlString) : new URL(urlString);
            if (!UrlTestEngine.testProtocol(url)) {
                return UrlStatusUtils.UNKNOWN_PROTOCOL;
            }
            return url;
        }
        catch (MalformedURLException mue) {
            try {
                URI uri = new URI(urlString);
                if (uri.isAbsolute()) {
                    return UrlStatusUtils.UNKNOWN_PROTOCOL;
                }
                return UrlStatusUtils.RELATIVE;
            }
            catch (URISyntaxException urise) {
                return UrlStatusUtils.MALFORMED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UrlStatus testConnection(URL url, int redirectionCount) {
        UrlStatus urlStatus = null;
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setInstanceFollowRedirects(false);
            urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64; rv:91.0) Gecko/20100101 Firefox/91.0");
            urlConnection.setConnectTimeout(1000);
            urlStatus = UrlTestEngine.build(url, urlConnection, redirectionCount);
        }
        catch (IOException ioe) {
            urlStatus = UrlStatusUtils.UNREACHABLE;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return urlStatus;
    }

    private static boolean testProtocol(URL url) {
        String protocol = url.getProtocol();
        if (protocol == null || protocol.isEmpty()) {
            return false;
        }
        switch (protocol) {
            case "http": 
            case "https": {
                return true;
            }
        }
        return false;
    }

    private static UrlStatus build(URL context, HttpURLConnection urlConnection, int redirectionCount) throws IOException {
        RedirectionUrl redirectionUrl = null;
        try {
            String status;
            int code = urlConnection.getResponseCode();
            if (code == -1) {
                return UrlStatusUtils.BAD_HTTP;
            }
            String responseMessage = urlConnection.getResponseMessage();
            switch (code) {
                case 200: {
                    return UrlStatusUtils.OK;
                }
                case 404: {
                    status = "not_found";
                    break;
                }
                default: {
                    if (code >= 300 && code < 400) {
                        status = "redirection";
                        redirectionUrl = UrlTestEngine.getRedirectionUrl(context, urlConnection, redirectionCount);
                        break;
                    }
                    status = "http_error";
                }
            }
            return new UrlStatus(status, code, responseMessage, redirectionUrl);
        }
        catch (SocketTimeoutException ste) {
            return UrlStatusUtils.TIMEOUT;
        }
    }

    private static RedirectionUrl getRedirectionUrl(URL context, HttpURLConnection urlConnection, int redirectionCount) {
        UrlStatus urlStatus;
        String redirectionLocation = urlConnection.getHeaderField("Location");
        if (redirectionLocation == null || redirectionLocation.isEmpty()) {
            return new RedirectionUrl("", UrlStatusUtils.MISSING_REDIRECTION);
        }
        if (redirectionCount >= 10) {
            urlStatus = UrlStatusUtils.REDIRECTION_LIMIT;
        } else {
            Object redirectionTest = UrlTestEngine.testUrl(context, redirectionLocation);
            if (redirectionTest instanceof UrlStatus) {
                urlStatus = (UrlStatus)redirectionTest;
            } else {
                URL redirectionUrl = (URL)redirectionTest;
                urlStatus = UrlTestEngine.testConnection(redirectionUrl, redirectionCount + 1);
                redirectionLocation = redirectionUrl.toString();
            }
        }
        return new RedirectionUrl(redirectionLocation, urlStatus);
    }
}

