/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.html;

import java.text.ParseException;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.html.MetaParam;
import net.mapeadores.util.html.MetaReport;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.MultiStringable;

public final class MetaReportUtils {
    private static final MetaParam[] TITLE = new MetaParam[]{new MetaParam("DublinCore", "Title"), new MetaParam("OpenGraph", "og:title"), new MetaParam("Schema", "name"), new MetaParam("Html", "title")};
    private static final MetaParam[] DESCRIPTION = new MetaParam[]{new MetaParam("DublinCore", "Description"), new MetaParam("OpenGraph", "og:description"), new MetaParam("Schema", "abstract"), new MetaParam("Html", "description")};
    private static final MetaParam[] AUTHORS = new MetaParam[]{new MetaParam("DublinCore", "Creator"), new MetaParam("OpenGraph", "article:author"), new MetaParam("Schema", "author"), new MetaParam("OpenGraph", "book:author"), new MetaParam("Html", "author")};
    private static final MetaParam[] DATE = new MetaParam[]{new MetaParam("DublinCore", "Date"), new MetaParam("OpenGraph", "article:published_time"), new MetaParam("Schema", "datePublished"), new MetaParam("OpenGraph", "book:release_date")};
    private static final MetaParam[] LANG = new MetaParam[]{new MetaParam("DublinCore", "Language"), new MetaParam("OpenGraph", "og:locale"), new MetaParam("Schema", "inLanguage"), new MetaParam("Html", "lang")};
    private static final MetaParam[] PUBLISHERS = new MetaParam[]{new MetaParam("DublinCore", "Publisher"), new MetaParam("Schema", "name"), new MetaParam("Html", "publisher")};
    private static final MetaParam[] KEYWORDS = new MetaParam[]{new MetaParam("DublinCore", "Subject"), new MetaParam("OpenGraph", "article:tag"), new MetaParam("Schema", "keywords"), new MetaParam("OpenGraph", "book:tag"), new MetaParam("Html", "keywords")};

    private MetaReportUtils() {
    }

    public static String getTitle(MetaReport metaReport) {
        MultiStringable multiStringable = metaReport.getValues(TITLE);
        if (multiStringable != null) {
            return multiStringable.getStringValue(0);
        }
        return null;
    }

    public static String getDescription(MetaReport metaReport) {
        MultiStringable multiStringable = metaReport.getValues(DESCRIPTION);
        if (multiStringable != null) {
            return multiStringable.toString("\n");
        }
        return null;
    }

    public static String[] getAuthors(MetaReport metaReport) {
        MultiStringable multiStringable = metaReport.getValues(AUTHORS);
        if (multiStringable != null) {
            return multiStringable.toStringArray();
        }
        return null;
    }

    public static FuzzyDate getDate(MetaReport metaReport) {
        MultiStringable multiStringable = metaReport.getValues(DATE);
        if (multiStringable != null) {
            String value = MetaReportUtils.cleanDate(multiStringable.getStringValue(0));
            try {
                return FuzzyDate.parse(value);
            }
            catch (ParseException pe) {
                return null;
            }
        }
        return null;
    }

    public static Lang getLang(MetaReport metaReport) {
        MultiStringable multiStringable = metaReport.getValues(LANG);
        if (multiStringable != null) {
            String value = MetaReportUtils.cleanLang(multiStringable.getStringValue(0));
            try {
                return Lang.parse(value);
            }
            catch (ParseException pe) {
                return null;
            }
        }
        return null;
    }

    public static String[] getPublishers(MetaReport metaReport) {
        MultiStringable multiStringable = metaReport.getValues(PUBLISHERS);
        if (multiStringable != null) {
            return multiStringable.toStringArray();
        }
        return null;
    }

    public static String[] getKeywords(MetaReport metaReport) {
        MultiStringable multiStringable = metaReport.getValues(KEYWORDS);
        if (multiStringable != null) {
            return multiStringable.toStringArray();
        }
        return null;
    }

    private static String cleanDate(String dateString) {
        int idx = dateString.indexOf(84);
        if (idx > 0) {
            return dateString.substring(0, idx);
        }
        return dateString;
    }

    private static String cleanLang(String langString) {
        return langString.replace('_', '-');
    }
}

