/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.html;

import java.util.Collection;
import java.util.Set;
import net.mapeadores.util.html.MetaParam;
import net.mapeadores.util.text.MultiStringable;

public interface MetaReport {
    public static final String HTML = "Html";
    public static final String DUBLIN_CORE = "DublinCore";
    public static final String OPENGRAPH = "OpenGraph";
    public static final String SCHEMA = "Schema";

    public Set<String> getAvalaibleProtocolSet();

    public ProtocolValues getProtocolValues(String var1);

    default public boolean containsProtocol(String protocol) {
        return this.getAvalaibleProtocolSet().contains(protocol);
    }

    default public MultiStringable getValues(Collection<MetaParam> metaParams) {
        for (MetaParam metaParam : metaParams) {
            MultiStringable values;
            ProtocolValues protocolValues = this.getProtocolValues(metaParam.getProtocol());
            if (protocolValues == null || (values = protocolValues.getValues(metaParam.getName())) == null) continue;
            return values;
        }
        return null;
    }

    default public MultiStringable getValues(MetaParam[] metaParams) {
        for (MetaParam metaParam : metaParams) {
            MultiStringable values;
            ProtocolValues protocolValues = this.getProtocolValues(metaParam.getProtocol());
            if (protocolValues == null || (values = protocolValues.getValues(metaParam.getName())) == null) continue;
            return values;
        }
        return null;
    }

    public static interface ProtocolValues {
        public String getProtocolName();

        public Set<String> getParamNameSet();

        public MultiStringable getValues(String var1);
    }
}

