/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.html;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.html.TrustedHtml;
import net.mapeadores.util.io.AppendableWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Litteral;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.MessageLocalisationPack;

public class HtmlPrinter {
    protected PrintWriter pw;
    private final MessageLocalisationPack messageLocalisationPack = new MessageLocalisationPack();
    private final MessageLocalisation messageLocalisation = this.messageLocalisationPack.getMessageLocalisationInterface();
    protected boolean breakLine = true;
    private boolean withJavascript = false;
    private int availableId = 1;

    public final void addMessageLocalisation(MessageLocalisation messageLocalisation) {
        this.addMessageLocalisation(messageLocalisation, 1);
    }

    public final void addMessageLocalisation(MessageLocalisation messageLocalisation, int priority) {
        if (messageLocalisation == null) {
            throw new NullPointerException("messageLocalisation is null");
        }
        this.messageLocalisationPack.addMessageLocalisation(messageLocalisation, priority);
    }

    public MessageLocalisation getMessageLocalisation() {
        return this.messageLocalisation;
    }

    public String generateId() {
        StringBuilder buf = new StringBuilder();
        buf.append("html-");
        if (this.availableId < 10) {
            buf.append("000");
        } else if (this.availableId < 100) {
            buf.append("00");
        } else if (this.availableId < 1000) {
            buf.append("0");
        }
        buf.append(this.availableId);
        ++this.availableId;
        return buf.toString();
    }

    public PrintWriter initPrinter(PrintWriter pw) {
        PrintWriter old = this.pw;
        this.pw = pw;
        return old;
    }

    public PrintWriter initPrinter(Appendable appendable) {
        PrintWriter old = this.pw;
        this.pw = appendable instanceof PrintWriter ? (PrintWriter)appendable : (appendable instanceof Writer ? new PrintWriter((Writer)appendable) : new PrintWriter(new AppendableWriter(appendable)));
        return old;
    }

    public final void setWithJavascript(boolean withJavascript) {
        this.withJavascript = withJavascript;
    }

    public boolean isWithJavascript() {
        return this.withJavascript;
    }

    public void flush() {
        this.pw.flush();
    }

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public HtmlAttributes name(String name) {
        return HA.name(name).id(this.generateId());
    }

    public HtmlPrinter __append(TrustedHtml trustedHtml) {
        this.pw.append(trustedHtml);
        return this;
    }

    public HtmlPrinter __escape(char c) {
        return this.__escape(c, false);
    }

    public HtmlPrinter __escape(char carac, boolean preformatted) {
        switch (carac) {
            case '&': {
                this.pw.print("&amp;");
                break;
            }
            case '\"': {
                this.pw.print("&quot;");
                break;
            }
            case '<': {
                this.pw.print("&lt;");
                break;
            }
            case '>': {
                this.pw.print("&gt;");
                break;
            }
            case '\'': {
                this.pw.print("&#x27;");
                break;
            }
            case '\\': {
                this.pw.print("&#x5C;");
                break;
            }
            case '`': {
                this.pw.print("&#x60;");
                break;
            }
            default: {
                if (!preformatted && carac < ' ') {
                    this.pw.print(' ');
                    break;
                }
                this.pw.print(carac);
            }
        }
        return this;
    }

    public HtmlPrinter __append(int i) {
        this.pw.print(i);
        return this;
    }

    public HtmlPrinter __append(long l) {
        this.pw.print(l);
        return this;
    }

    public HtmlPrinter __colon() {
        this.__localize("_ label.global.colon");
        this.__space();
        return this;
    }

    public HtmlPrinter __dash() {
        this.pw.print(" \u2013 ");
        return this;
    }

    public HtmlPrinter __space() {
        this.pw.print(' ');
        return this;
    }

    public HtmlPrinter __newLine() {
        this.pw.print('\n');
        return this;
    }

    public HtmlPrinter __nonBreakableSpace() {
        this.pw.print("&nbsp;");
        return this;
    }

    public HtmlPrinter __doublespace() {
        this.pw.print("&nbsp; ");
        return this;
    }

    public HtmlPrinter __escape(Object obj) {
        if (obj == null) {
            this.pw.print("null");
            return this;
        }
        return this.__escape(obj.toString());
    }

    public HtmlPrinter __escape(CharSequence s) {
        return this.__escape(s, false);
    }

    public HtmlPrinter __escape(CharSequence s, boolean preformatted) {
        if (s == null) {
            this.pw.print("null");
            return this;
        }
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            this.__escape(s.charAt(i), preformatted);
        }
        return this;
    }

    public HtmlPrinter __breakLine() {
        if (this.breakLine) {
            this.pw.println("");
        }
        return this;
    }

    public HtmlPrinter __jsObject(String name, JsObject jsObject) {
        this.__escape(name).__escape(" = ").__(jsObject.print(this)).__scriptLineEnd();
        return this;
    }

    public HtmlPrinter __jsObject(String declaration, String name, JsObject jsObject) {
        this.__escape(declaration).__space().__escape(name).__escape(" = ").__(jsObject.print(this)).__scriptLineEnd();
        return this;
    }

    public HtmlPrinter __jsAssignObject(String name, JsObject jsObject) {
        this.__escape("Object.assign(").__escape(name).__escape(",").__(jsObject.print(this)).__escape(")").__scriptLineEnd();
        return this;
    }

    public HtmlPrinter __scriptLineEnd() {
        this.pw.println(";");
        return this;
    }

    public HtmlPrinter __scriptLiteral(CharSequence s) {
        if (s == null) {
            this.pw.print("null");
            return this;
        }
        this.pw.print('\"');
        int length = s.length();
        block11: for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            switch (carac) {
                case '\n': {
                    this.pw.print("\\n");
                    continue block11;
                }
                case '\t': {
                    this.pw.print("\\t");
                    continue block11;
                }
                case '\r': {
                    this.pw.print("\\r");
                    continue block11;
                }
                case '\"': {
                    this.pw.print("\\\"");
                    continue block11;
                }
                case '\'': {
                    this.pw.print("\\'");
                    continue block11;
                }
                case '\\': {
                    this.pw.print("\\\\");
                    continue block11;
                }
                case '<': {
                    this.pw.print("\\u003c");
                    continue block11;
                }
                case '>': {
                    this.pw.print("\\u003e");
                    continue block11;
                }
                case '&': {
                    this.pw.print("\\u0026");
                    continue block11;
                }
                default: {
                    if (carac < ' ') {
                        this.pw.print(' ');
                        continue block11;
                    }
                    this.pw.print(carac);
                }
            }
        }
        this.pw.print('\"');
        return this;
    }

    public String getLocalization(String messageKey) {
        String loc = this.messageLocalisation.toString(messageKey);
        if (loc == null) {
            loc = "?" + messageKey + "?";
        }
        return loc;
    }

    public String getLocalization(String messageKey, Object ... messageValues) {
        String loc = this.messageLocalisation.toString(messageKey, messageValues);
        if (loc == null) {
            loc = "?" + messageKey + "?";
        }
        return loc;
    }

    public String getLocalization(Message message) {
        String loc = this.messageLocalisation.toString(message);
        if (loc == null) {
            loc = "?" + message.getMessageKey() + "?";
        }
        return loc;
    }

    public HtmlPrinter __localize(String messageKey) {
        this.__escape(this.getLocalization(messageKey));
        return this;
    }

    public HtmlPrinter __localize(String messageKey, Object ... messageValues) {
        this.__escape(this.getLocalization(messageKey, messageValues));
        return this;
    }

    public HtmlPrinter __localize(Message message) {
        this.__escape(this.getLocalization(message));
        return this;
    }

    public HtmlPrinter __localize(Object l10nObject) {
        if (l10nObject instanceof String) {
            return this.__localize((String)l10nObject);
        }
        if (l10nObject instanceof Message) {
            return this.__localize((Message)l10nObject);
        }
        if (l10nObject instanceof Litteral) {
            return this.__escape(l10nObject.toString());
        }
        if (l10nObject instanceof Runnable) {
            return this.__((Runnable)l10nObject);
        }
        if (l10nObject instanceof Consumer) {
            return this.__((Consumer)l10nObject);
        }
        return this.__localize(l10nObject.toString());
    }

    public HtmlPrinter __(boolean b) {
        return this;
    }

    public HtmlPrinter __(@Nullable Consumer<HtmlPrinter> consumer) {
        if (consumer != null) {
            consumer.accept(this);
        }
        return this;
    }

    public HtmlPrinter __(@Nullable Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
        return this;
    }

    public HtmlPrinter __(@Nullable BiConsumer<HtmlPrinter, Object> biconsumer, Object argument) {
        if (biconsumer != null) {
            biconsumer.accept(this, argument);
        }
        return this;
    }

    public HtmlPrinter __(@Nullable HtmlWrapper wrapper, @Nullable Consumer<HtmlPrinter> consumer) {
        if (wrapper != null) {
            if (consumer != null) {
                wrapper.wrap(this, consumer);
            }
        } else if (consumer != null) {
            consumer.accept(this);
        }
        return this;
    }

    public HtmlPrinter __(@Nullable HtmlWrapper wrapper, @Nullable Runnable runnable) {
        if (wrapper != null) {
            if (runnable != null) {
                wrapper.wrap(this, runnable);
            }
        } else if (runnable != null) {
            runnable.run();
        }
        return this;
    }

    public HtmlPrinter __if(boolean condition, @Nullable Consumer<HtmlPrinter> consumer) {
        if (condition && consumer != null) {
            consumer.accept(this);
        }
        return this;
    }

    public HtmlPrinter __if(boolean condition, @Nullable Runnable runnable) {
        if (condition && runnable != null) {
            runnable.run();
        }
        return this;
    }

    public HtmlPrinter __start(Object o) {
        return this;
    }

    public HtmlPrinter __end(Object o) {
        return this;
    }

    public HtmlPrinter A(HtmlAttributes htmlAttributes) {
        this.openTag("a");
        if (htmlAttributes != null) {
            this.printAttribute("href", htmlAttributes.href());
            this.printAttribute("target", htmlAttributes.target());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _A() {
        this.endTag("a");
        return this;
    }

    public HtmlPrinter BODY() {
        this.startTag("body");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter BODY(String classes) {
        this.openTag("body");
        this.printAttribute("class", classes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter BODY(HtmlAttributes htmlAttributes) {
        this.openTag("body");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _BODY() {
        this.endTag("body");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter BR() {
        this.startTag("br");
        return this;
    }

    public HtmlPrinter BUTTON(HtmlAttributes htmlAttributes) {
        this.openTag("button");
        this.printHTMLAttributes(htmlAttributes);
        this.printBooleanAttribute("disabled", htmlAttributes.disabled());
        this.printAttribute("type", htmlAttributes.type());
        this.closeTag();
        return this;
    }

    public HtmlPrinter _BUTTON() {
        this.endTag("button");
        return this;
    }

    public HtmlPrinter COL(String classes) {
        this.openTag("col");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter COL(HtmlAttributes htmlAttributes) {
        this.openTag("col");
        if (htmlAttributes != null) {
            this.printAttribute("width", htmlAttributes.width());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter CODE() {
        this.startTag("code");
        return this;
    }

    public HtmlPrinter CODE(String classes) {
        this.openTag("code");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter CODE(HtmlAttributes htmlAttributes) {
        this.openTag("code");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _CODE() {
        this.endTag("code");
        return this;
    }

    public HtmlPrinter COMMENT() {
        this.pw.print("<!-- ");
        return this;
    }

    public HtmlPrinter _COMMENT() {
        this.pw.print(" -->");
        return this;
    }

    public HtmlPrinter DD() {
        this.startTag("dd");
        return this;
    }

    public HtmlPrinter DD(String classes) {
        this.openTag("dd");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter DD(HtmlAttributes htmlAttributes) {
        this.openTag("dd");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _DD() {
        this.endTag("dd");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter DEL() {
        this.startTag("del");
        return this;
    }

    public HtmlPrinter DEL(HtmlAttributes htmlAttributes) {
        this.openTag("del");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _DEL() {
        this.endTag("del");
        return this;
    }

    public HtmlPrinter DETAILS() {
        this.startTag("details");
        return this;
    }

    public HtmlPrinter DETAILS(String classes) {
        this.openTag("details");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter DETAILS(HtmlAttributes htmlAttributes) {
        this.openTag("details");
        if (htmlAttributes != null) {
            this.printBooleanAttribute("open", htmlAttributes.open());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _DETAILS() {
        this.endTag("details");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter DIV() {
        this.startTag("div");
        return this;
    }

    public HtmlPrinter DIV(String classes) {
        this.openTag("div");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter DIV(HtmlAttributes htmlAttributes) {
        this.openTag("div");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _DIV() {
        this.endTag("div");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter DL() {
        this.startTag("dl");
        return this;
    }

    public HtmlPrinter DL(String classes) {
        this.openTag("dl");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter DL(HtmlAttributes htmlAttributes) {
        this.openTag("dl");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _DL() {
        this.endTag("dl");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter DOCTYPE_html5() {
        this.pw.println("<!DOCTYPE html>");
        return this;
    }

    public HtmlPrinter DOCTYPE_frameset() {
        this.pw.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">");
        return this;
    }

    public HtmlPrinter DT() {
        this.startTag("dt");
        return this;
    }

    public HtmlPrinter DT(String classes) {
        this.openTag("dt");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter DT(HtmlAttributes htmlAttributes) {
        this.openTag("dt");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _DT() {
        this.endTag("dt");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter EM() {
        this.startTag("em");
        return this;
    }

    public HtmlPrinter EM(HtmlAttributes htmlAttributes) {
        this.openTag("em");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _EM() {
        this.endTag("em");
        return this;
    }

    public HtmlPrinter FIELDSET() {
        this.startTag("fieldset");
        return this;
    }

    public HtmlPrinter FIELDSET(String classes) {
        this.openTag("fieldset");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter FIELDSET(HtmlAttributes htmlAttributes) {
        this.openTag("fieldset");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _FIELDSET() {
        this.endTag("fieldset");
        return this;
    }

    public HtmlPrinter FORM(String method, String action, String target, String enctype) {
        this.openTag("form");
        this.printAttribute("action", action);
        this.printAttribute("method", method);
        this.printAttribute("target", target);
        this.printAttribute("enctype", enctype);
        this.closeTag();
        return this;
    }

    public HtmlPrinter FORM(HtmlAttributes htmlAttributes) {
        this.openTag("form");
        if (htmlAttributes != null) {
            this.printAttribute("action", htmlAttributes.action());
            this.printAttribute("method", htmlAttributes.method());
            this.printAttribute("target", htmlAttributes.target());
            this.printAttribute("enctype", htmlAttributes.enctype());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter FORM_get(String action) {
        return this.FORM("GET", action, null, null);
    }

    public HtmlPrinter FORM_get(String action, String target) {
        return this.FORM("GET", action, target, null);
    }

    public HtmlPrinter FORM_get(HtmlAttributes htmlAttributes) {
        return this.FORM(htmlAttributes.method("GET"));
    }

    public HtmlPrinter FORM_post(String action) {
        return this.FORM("POST", action, null, null);
    }

    public HtmlPrinter FORM_post(String action, String target) {
        return this.FORM("POST", action, target, null);
    }

    public HtmlPrinter FORM_post(String action, String target, String enctype) {
        return this.FORM("POST", action, target, enctype);
    }

    public HtmlPrinter FORM_post(HtmlAttributes htmlAttributes) {
        return this.FORM(htmlAttributes.method("POST"));
    }

    public HtmlPrinter _FORM() {
        this.endTag("form");
        return this;
    }

    public HtmlPrinter FRAME(HtmlAttributes htmlAttributes) {
        this.openTag("frame");
        if (htmlAttributes != null) {
            this.printAttribute("src", htmlAttributes.src());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter FRAMESET(HtmlAttributes htmlAttributes) {
        this.openTag("frameset");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _FRAMESET() {
        this.endTag("frameset");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter H1() {
        this.startTag("h1");
        return this;
    }

    public HtmlPrinter H1(String classes) {
        this.openTag("h1");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter H1(HtmlAttributes htmlAttributes) {
        this.openTag("h1");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _H1() {
        this.endTag("h1");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter H2() {
        this.startTag("h2");
        return this;
    }

    public HtmlPrinter H2(String classes) {
        this.openTag("h2");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter H2(HtmlAttributes htmlAttributes) {
        this.openTag("h2");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _H2() {
        this.endTag("h2");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter H3() {
        this.startTag("h3");
        return this;
    }

    public HtmlPrinter H3(String classes) {
        this.openTag("h3");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter H3(HtmlAttributes htmlAttributes) {
        this.openTag("h3");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _H3() {
        this.endTag("h3");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter H4() {
        this.startTag("h4");
        return this;
    }

    public HtmlPrinter H4(String classes) {
        this.openTag("h4");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter H4(HtmlAttributes htmlAttributes) {
        this.openTag("h4");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _H4() {
        this.endTag("h4");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter H5() {
        this.startTag("h5");
        return this;
    }

    public HtmlPrinter H5(String classes) {
        this.openTag("h5");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter H5(HtmlAttributes htmlAttributes) {
        this.openTag("h5");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _H5() {
        this.endTag("h5");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter H6() {
        this.startTag("h6");
        return this;
    }

    public HtmlPrinter H6(String classes) {
        this.openTag("h6");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter H6(HtmlAttributes htmlAttributes) {
        this.openTag("h6");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _H6() {
        this.endTag("h6");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter HEAD() {
        this.startTag("head");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter HEAD(HtmlAttributes htmlAttributes) {
        this.openTag("head");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _HEAD() {
        this.endTag("head");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter HEADER() {
        this.startTag("header");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter HEADER(String classes) {
        this.openTag("header");
        this.printAttribute("class", classes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter HEADER(HtmlAttributes htmlAttributes) {
        this.openTag("header");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _HEADER() {
        this.endTag("header");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter HR() {
        this.startTag("hr");
        return this;
    }

    public HtmlPrinter HR(String classes) {
        this.openTag("hr");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter HR(HtmlAttributes htmlAttributes) {
        this.openTag("hr");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter HTML() {
        this.startTag("html");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter HTML(Lang lang) {
        this.openTag("html");
        if (lang != null) {
            this.printAttribute("lang", lang.toString());
            if (lang.isRTLScript()) {
                this.printAttribute("dir", "rtl");
            }
        }
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _HTML() {
        this.endTag("html");
        return this;
    }

    public HtmlPrinter IFRAME(HtmlAttributes htmlAttributes) {
        this.openTag("iframe");
        if (htmlAttributes != null) {
            this.printAttribute("src", htmlAttributes.src());
            this.printAttribute("width", htmlAttributes.width());
            this.printAttribute("height", htmlAttributes.height());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _IFRAME() {
        this.endTag("iframe");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter IMG(HtmlAttributes htmlAttributes) {
        this.openTag("img");
        if (htmlAttributes != null) {
            this.printAttribute("src", htmlAttributes.src());
            this.printAttribute("alt", htmlAttributes.alt());
            this.printAttribute("width", htmlAttributes.width());
            this.printAttribute("height", htmlAttributes.height());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter INPUT(HtmlAttributes htmlAttributes) {
        return this.INPUT(htmlAttributes, false);
    }

    public HtmlPrinter INPUT(HtmlAttributes htmlAttributes, boolean preformatted) {
        this.openTag("input");
        if (htmlAttributes != null) {
            this.printAttribute("type", htmlAttributes.type());
            this.printPreformattedAttribute("value", htmlAttributes.value(), preformatted);
            this.printAttribute("pattern", htmlAttributes.pattern());
            this.printAttribute("size", htmlAttributes.size());
            this.printBooleanAttribute("checked", htmlAttributes.checked());
            this.printBooleanAttribute("disabled", htmlAttributes.disabled());
            this.printBooleanAttribute("readonly", htmlAttributes.readonly());
            this.printBooleanAttribute("required", htmlAttributes.required());
            this.printBooleanAttribute("multiple", htmlAttributes.multiple());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter INPUT_checkbox(HtmlAttributes htmlAttributes) {
        return this.INPUT(htmlAttributes.type("checkbox"), false);
    }

    public HtmlPrinter INPUT_hidden(String name, String value) {
        this.openTag("input");
        this.printAttribute("type", "hidden");
        this.printAttribute("name", name);
        this.printAttribute("value", value);
        this.closeTag();
        return this;
    }

    public HtmlPrinter INPUT_hidden(Map<String, String> hiddenParametersMap) {
        for (Map.Entry<String, String> entry : hiddenParametersMap.entrySet()) {
            this.INPUT_hidden(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HtmlPrinter INPUT_radio(HtmlAttributes htmlAttributes) {
        return this.INPUT(htmlAttributes.type("radio"), false);
    }

    public HtmlPrinter INPUT_text(HtmlAttributes htmlAttributes) {
        return this.INPUT(htmlAttributes.type("text"), false);
    }

    public HtmlPrinter LABEL() {
        this.startTag("label");
        return this;
    }

    public HtmlPrinter LABEL(String classes) {
        this.openTag("label");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter LABEL(HtmlAttributes htmlAttributes) {
        this.openTag("label");
        if (htmlAttributes != null) {
            this.printAttribute("for", htmlAttributes.forId());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter LABEL_for(String forId) {
        this.openTag("label");
        this.printAttribute("for", forId);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _LABEL() {
        this.endTag("label");
        return this;
    }

    public HtmlPrinter LEGEND() {
        this.startTag("legend");
        return this;
    }

    public HtmlPrinter LEGEND(String classes) {
        this.openTag("legend");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter LEGEND(HtmlAttributes htmlAttributes) {
        this.openTag("legend");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _LEGEND() {
        this.endTag("legend");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter LI() {
        this.startTag("li");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter LI(String classes) {
        this.openTag("li");
        this.printAttribute("class", classes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter LI(HtmlAttributes htmlAttributes) {
        this.openTag("li");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _LI() {
        this.endTag("li");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter LINK(HtmlAttributes htmlAttributes) {
        this.openTag("link");
        if (htmlAttributes != null) {
            this.printAttribute("href", htmlAttributes.href());
            this.printAttribute("rel", htmlAttributes.rel());
            this.printAttribute("type", htmlAttributes.type());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter MAIN() {
        this.startTag("main");
        return this;
    }

    public HtmlPrinter MAIN(String classes) {
        this.openTag("main");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter MAIN(HtmlAttributes htmlAttributes) {
        this.openTag("main");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _MAIN() {
        this.endTag("main");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter META(HtmlAttributes htmlAttributes) {
        this.openTag("meta");
        if (htmlAttributes != null) {
            this.printAttribute("http-equiv", htmlAttributes.httpEquiv());
            this.printAttribute("content", htmlAttributes.content());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter META_htmlcontenttype() {
        this.openTag("meta");
        this.printAttribute("http-equiv", "Content-Type");
        this.printAttribute("content", "text/html; charset=UTF-8");
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter NAV() {
        this.startTag("nav");
        return this;
    }

    public HtmlPrinter NAV(String classes) {
        this.openTag("nav");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter NAV(HtmlAttributes htmlAttributes) {
        this.openTag("nav");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _NAV() {
        this.endTag("nav");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter NOSCRIPT() {
        this.startTag("noscript");
        return this;
    }

    public HtmlPrinter _NOSCRIPT() {
        this.endTag("noscript");
        return this;
    }

    public HtmlPrinter OPTGROUP(HtmlAttributes htmlAttributes) {
        this.openTag("optgroup");
        if (htmlAttributes != null) {
            this.printAttribute("label", htmlAttributes.label());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _OPTGROUP() {
        this.endTag("optgroup");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter OPTION(String value, boolean selected) {
        this.openTag("option");
        this.printAttribute("value", value);
        this.printBooleanAttribute("selected", selected);
        this.closeTag();
        return this;
    }

    public HtmlPrinter OPTION(String value, String current) {
        boolean selected = false;
        if (value.equals(current)) {
            selected = true;
        }
        return this.OPTION(value, selected);
    }

    public HtmlPrinter OPTION(HtmlAttributes htmlAttributes) {
        this.openTag("option");
        if (htmlAttributes != null) {
            this.printAttribute("value", htmlAttributes.value());
            this.printBooleanAttribute("selected", htmlAttributes.selected());
            this.printBooleanAttribute("disabled", htmlAttributes.disabled());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _OPTION() {
        this.endTag("option");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter P() {
        this.startTag("p");
        return this;
    }

    public HtmlPrinter P(String classes) {
        this.openTag("p");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter P(HtmlAttributes htmlAttributes) {
        this.openTag("p");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _P() {
        this.endTag("p");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter PRE() {
        this.startTag("pre");
        return this;
    }

    public HtmlPrinter PRE(String classes) {
        this.openTag("pre");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter PRE(HtmlAttributes htmlAttributes) {
        this.openTag("pre");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _PRE() {
        this.endTag("pre");
        return this;
    }

    public HtmlPrinter SCRIPT() {
        this.startTag("script");
        return this;
    }

    public HtmlPrinter SCRIPT(HtmlAttributes htmlAttributes) {
        this.openTag("script");
        if (htmlAttributes != null) {
            this.printAttribute("type", htmlAttributes.type());
            this.printAttribute("src", htmlAttributes.src());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _SCRIPT() {
        this.endTag("script");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter SECTION() {
        this.startTag("section");
        return this;
    }

    public HtmlPrinter SECTION(String classes) {
        this.openTag("section");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter SECTION(HtmlAttributes htmlAttributes) {
        this.openTag("section");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _SECTION() {
        this.endTag("section");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter SELECT(String name) {
        this.openTag("select");
        this.printAttribute("name", name);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter SELECT(HtmlAttributes htmlAttributes) {
        this.openTag("select");
        this.printHTMLAttributes(htmlAttributes);
        this.printBooleanAttribute("multiple", htmlAttributes.multiple());
        this.printAttribute("size", htmlAttributes.size());
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _SELECT() {
        this.endTag("select");
        return this;
    }

    public HtmlPrinter SMALL() {
        this.startTag("small");
        return this;
    }

    public HtmlPrinter _SMALL() {
        this.endTag("small");
        return this;
    }

    public HtmlPrinter SPAN() {
        this.startTag("span");
        return this;
    }

    public HtmlPrinter SPAN(String classes) {
        this.openTag("span");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter SPAN(HtmlAttributes htmlAttributes) {
        this.openTag("span");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _SPAN() {
        this.endTag("span");
        return this;
    }

    public HtmlPrinter STRONG() {
        this.startTag("strong");
        return this;
    }

    public HtmlPrinter STRONG(HtmlAttributes htmlAttributes) {
        this.openTag("strong");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _STRONG() {
        this.endTag("strong");
        return this;
    }

    public HtmlPrinter STYLE() {
        this.startTag("style");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter STYLE(HtmlAttributes htmlAttributes) {
        this.openTag("style");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _STYLE() {
        this.endTag("style");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter SUMMARY() {
        this.startTag("summary");
        return this;
    }

    public HtmlPrinter SUMMARY(String classes) {
        this.openTag("summary");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter SUMMARY(HtmlAttributes htmlAttributes) {
        this.openTag("summary");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _SUMMARY() {
        this.endTag("summary");
        return this;
    }

    public HtmlPrinter TABLE() {
        this.startTag("table");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter TABLE(String classes) {
        this.openTag("table");
        this.printAttribute("class", classes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter TABLE(HtmlAttributes htmlAttributes) {
        this.openTag("table");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _TABLE() {
        this.endTag("table");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter TBODY() {
        this.startTag("tbody");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter TBODY(HtmlAttributes htmlAttributes) {
        this.openTag("tbody");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _TBODY() {
        this.endTag("tbody");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter TD() {
        this.startTag("td");
        return this;
    }

    public HtmlPrinter TD(String classes) {
        this.openTag("td");
        this.printAttribute("class", classes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter TD(HtmlAttributes htmlAttributes) {
        this.openTag("td");
        if (htmlAttributes != null) {
            int rowSpan;
            int colSpan = htmlAttributes.colspan();
            if (colSpan > 1) {
                this.printAttribute("colspan", String.valueOf(colSpan));
            }
            if ((rowSpan = htmlAttributes.rowspan()) > 1) {
                this.printAttribute("rowspan", String.valueOf(rowSpan));
            }
            this.printAttribute("width", htmlAttributes.width());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _TD() {
        this.endTag("td");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter TEXTAREA(HtmlAttributes htmlAttributes) {
        this.openTag("textarea");
        int cols = 0;
        int rows = 0;
        if (htmlAttributes != null) {
            cols = htmlAttributes.cols();
            rows = htmlAttributes.rows();
        }
        if (cols < 1) {
            cols = 50;
        }
        if (rows < 1) {
            rows = 3;
        }
        this.printAttribute("cols", String.valueOf(cols));
        this.printAttribute("rows", String.valueOf(rows));
        this.printBooleanAttribute("disabled", htmlAttributes.disabled());
        this.printBooleanAttribute("readonly", htmlAttributes.readonly());
        this.printBooleanAttribute("required", htmlAttributes.required());
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _TEXTAREA() {
        this.endTag("textarea");
        return this;
    }

    public HtmlPrinter TFOOT() {
        this.startTag("tfoot");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter TFOOT(HtmlAttributes htmlAttributes) {
        this.openTag("tfoot");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _TFOOT() {
        this.endTag("tfoot");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter TH() {
        this.startTag("th");
        return this;
    }

    public HtmlPrinter TH(HtmlAttributes htmlAttributes) {
        this.openTag("th");
        if (htmlAttributes != null) {
            int rowSpan;
            int colSpan = htmlAttributes.colspan();
            if (colSpan > 1) {
                this.printAttribute("colspan", String.valueOf(colSpan));
            }
            if ((rowSpan = htmlAttributes.rowspan()) > 1) {
                this.printAttribute("rowspan", String.valueOf(rowSpan));
            }
            this.printAttribute("width", htmlAttributes.width());
        }
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _TH() {
        this.endTag("th");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter THEAD() {
        this.startTag("thead");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter THEAD(HtmlAttributes htmlAttributes) {
        this.openTag("thead");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _THEAD() {
        this.endTag("thead");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter TITLE() {
        this.startTag("title");
        return this;
    }

    public HtmlPrinter TITLE(HtmlAttributes htmlAttributes) {
        this.openTag("title");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        return this;
    }

    public HtmlPrinter _TITLE() {
        this.endTag("title");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter TR() {
        this.startTag("tr");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter TR(HtmlAttributes htmlAttributes) {
        this.openTag("tr");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _TR() {
        this.endTag("tr");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter UL() {
        this.startTag("ul");
        this.__breakLine();
        return this;
    }

    public HtmlPrinter UL(String classes) {
        this.openTag("ul");
        this.printAttribute("class", classes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter UL(HtmlAttributes htmlAttributes) {
        this.openTag("ul");
        this.printHTMLAttributes(htmlAttributes);
        this.closeTag();
        this.__breakLine();
        return this;
    }

    public HtmlPrinter _UL() {
        this.endTag("ul");
        this.__breakLine();
        return this;
    }

    private boolean printHTMLAttributes(HtmlAttributes htmlAttributes) {
        if (htmlAttributes == null) {
            return false;
        }
        this.printAttribute("class", htmlAttributes.classes());
        this.printAttribute("id", htmlAttributes.id());
        this.printAttribute("style", htmlAttributes.style());
        this.printAttribute("name", htmlAttributes.name());
        Map<String, String> attrMap = htmlAttributes.getAttrMap();
        if (attrMap != null) {
            for (Map.Entry<String, String> entry : attrMap.entrySet()) {
                this.pw.print(" ");
                this.__escape(entry.getKey());
                this.pw.print("=\"");
                this.__escape(entry.getValue());
                this.pw.print("\"");
            }
        }
        this.printAttributeObject(htmlAttributes.getTitleType(), "title", htmlAttributes.title());
        return true;
    }

    private void printAttributeObject(short type, String name, Object object) {
        switch (type) {
            case 1: {
                this.printAttribute(name, (String)object);
                break;
            }
            case 2: {
                this.printLocAttribute(name, (String)object);
                break;
            }
            case 3: {
                this.printLocAttribute(name, (Message)object);
            }
        }
    }

    private void printAttribute(String name, String value) {
        if (value == null) {
            return;
        }
        this.pw.print(" ");
        this.pw.print(name);
        this.pw.print("=\"");
        this.__escape(value);
        this.pw.print("\"");
    }

    private void printLocAttribute(String name, String locKey) {
        if (locKey == null) {
            return;
        }
        this.pw.print(" ");
        this.pw.print(name);
        this.pw.print("=\"");
        this.__localize(locKey);
        this.pw.print("\"");
    }

    private void printLocAttribute(String name, Message message) {
        if (message == null) {
            return;
        }
        this.pw.print(" ");
        this.pw.print(name);
        this.pw.print("=\"");
        this.__localize(message);
        this.pw.print("\"");
    }

    private void printBooleanAttribute(String name, boolean value) {
        if (value) {
            this.printAttribute(name, name);
        }
    }

    private void startTag(String tag) {
        this.pw.print("<");
        this.pw.print(tag);
        this.pw.print(">");
    }

    private void openTag(String tag) {
        this.pw.print("<");
        this.pw.print(tag);
    }

    private void closeTag() {
        this.pw.print(">");
    }

    private void endTag(String tag) {
        this.pw.print("</");
        this.pw.print(tag);
        this.pw.print(">");
    }

    private void printPreformattedAttribute(String name, String value, boolean preformatted) {
        if (value == null) {
            return;
        }
        this.pw.print(" ");
        this.pw.print(name);
        this.pw.print("=\"");
        this.__escape(value, preformatted);
        this.pw.print("\"");
    }
}

