/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.geometry;

import net.mapeadores.util.geometry.CartesianPoint;

public class CartesianUtils {
    public static final double deuxpi = Math.PI * 2;
    public static final int NORTH = 1;
    public static final int NORTH_EAST = 2;
    public static final int EAST = 3;
    public static final int SOUTH_EAST = 4;
    public static final int SOUTH = 5;
    public static final int SOUTH_WEST = 6;
    public static final int WEST = 7;
    public static final int NORTH_WEST = 8;

    private CartesianUtils() {
    }

    public static double modulo2pi(double angle) {
        return angle - Math.floor(angle / (Math.PI * 2)) * (Math.PI * 2);
    }

    public static CartesianPoint getAngleIntersection(CartesianPoint cartesianCenter, double angle, int a, int b) {
        double sinAngle = Math.sin(angle);
        double cosAngle = Math.cos(angle);
        double sinDim = (double)b / CartesianPoint.norme(a, b);
        int x = 0;
        int y = 0;
        if (Math.abs(sinAngle) > Math.abs(sinDim)) {
            y = sinAngle > 0.0 ? b : -b;
            x = (int)Math.round((double)y * cosAngle / sinAngle);
        } else {
            x = cosAngle > 0.0 ? a : -a;
            y = (int)Math.round((double)x * sinAngle / cosAngle);
        }
        return new CartesianPoint(x + cartesianCenter.x, y + cartesianCenter.y);
    }

    public static Intersection getAngleIntersection(CartesianPoint cartesianCenter, double angle, int east, int west, int north, int south) {
        if (east <= 0 || north <= 0 || south >= 0 || west >= 0) {
            throw new IllegalArgumentException();
        }
        double sinAngle = Math.sin(angle);
        double cosAngle = Math.cos(angle);
        int x = 0;
        int y = 0;
        int refx = cosAngle >= 0.0 ? east : west;
        int refy = sinAngle >= 0.0 ? north : south;
        int intersectedDirection = 0;
        double sinDim = (double)refy / CartesianPoint.norme(refx, refy);
        if (Math.abs(sinAngle) > Math.abs(sinDim)) {
            intersectedDirection = sinAngle > 0.0 ? 1 : 5;
            y = refy;
            x = (int)Math.round((double)y * cosAngle / sinAngle);
        } else {
            intersectedDirection = cosAngle > 0.0 ? 3 : 7;
            x = refx;
            y = (int)Math.round((double)x * sinAngle / cosAngle);
        }
        return new Intersection(intersectedDirection, x + cartesianCenter.x, y + cartesianCenter.y);
    }

    public static class Intersection {
        CartesianPoint cartesianPoint;
        int intersectedDirection;

        Intersection(int intersectedDirection, int x, int y) {
            this.intersectedDirection = intersectedDirection;
            this.cartesianPoint = new CartesianPoint(x, y);
        }

        public CartesianPoint getCartesianPoint() {
            return this.cartesianPoint;
        }

        public int getIntersectedDirection() {
            return this.intersectedDirection;
        }
    }
}

