/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.geoloc;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.primitives.DegrePoint;
import net.mapeadores.util.text.StringUtils;

public final class GeolocUtils {
    private static final Map<String, DegrePoint> countryGeolocMap = new HashMap<String, DegrePoint>();

    private GeolocUtils() {
    }

    public static DegrePoint getCountryGeoloc(String countryCode) {
        return countryGeolocMap.get(countryCode);
    }

    static {
        try (InputStream is = GeolocUtils.class.getResourceAsStream("geoloc_country.ini");){
            HashMap<String, String> iniMap = new HashMap<String, String>();
            IniParser.parseIni(is, iniMap);
            for (Map.Entry entry : iniMap.entrySet()) {
                String value = (String)entry.getValue();
                int idx = value.indexOf(44);
                DegreDecimal latitude = DegreDecimal.newInstance(StringUtils.parseDecimal(value.substring(0, idx).trim()));
                DegreDecimal longitude = DegreDecimal.newInstance(StringUtils.parseDecimal(value.substring(idx + 1).trim()));
                countryGeolocMap.put((String)entry.getKey(), new DegrePoint(latitude, longitude));
            }
            iniMap.clear();
        }
        catch (IOException ioe) {
            throw new InternalResourceException(ioe);
        }
        catch (NumberFormatException nfe) {
            throw new InternalResourceException(nfe);
        }
    }
}

