/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.date;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.mapeadores.util.date.DateUtils;
import net.mapeadores.util.date.FuzzyDate;

public class FuzzyDateFormatter {
    private static final Map<String, FuzzyDateFormatter> internMap = new HashMap<String, FuzzyDateFormatter>();
    private final FormatStyle formatStyle;
    private final Locale locale;
    private final String dayPattern;
    private final String monthPattern;
    private final String quarterPattern;
    private final DateTimeFormatter dayFormatter;
    private final DateTimeFormatter monthFormatter;
    private final DateTimeFormatter quarterFormatter;
    private final ResourceBundle dateBundle;

    private FuzzyDateFormatter(FormatStyle formatStyle, Locale locale, String dayPattern, String monthPattern, String quarterPattern) {
        this.formatStyle = formatStyle;
        this.locale = locale;
        this.dayPattern = dayPattern;
        this.monthPattern = monthPattern;
        this.quarterPattern = quarterPattern;
        this.dayFormatter = new DateTimeFormatterBuilder().appendPattern(dayPattern).toFormatter(locale);
        this.monthFormatter = new DateTimeFormatterBuilder().appendPattern(monthPattern).toFormatter(locale);
        this.quarterFormatter = new DateTimeFormatterBuilder().appendPattern(quarterPattern).toFormatter(locale);
        this.dateBundle = ResourceBundle.getBundle("net.mapeadores.util.date.resources.DateResourceBundle", locale);
    }

    public FormatStyle getFormatStyle() {
        return this.formatStyle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getPattern(String fuzzyDateType) {
        switch (fuzzyDateType) {
            case "year": {
                return "y";
            }
            case "halfyear": {
                return "y-M";
            }
            case "quarter": {
                return this.quarterPattern;
            }
            case "month": {
                return this.monthPattern;
            }
            case "day": {
                return this.dayPattern;
            }
        }
        throw new IllegalArgumentException("Unknown fuzzyDateType = " + fuzzyDateType);
    }

    public String format(FuzzyDate fuzzyDate) {
        switch (fuzzyDate.getDateType()) {
            case "year": {
                return fuzzyDate.toString();
            }
            case "halfyear": {
                return this.formatHalfYear(fuzzyDate);
            }
            case "quarter": {
                return this.quarterFormatter.format(fuzzyDate.toLocalDate());
            }
            case "month": {
                return this.monthFormatter.format(fuzzyDate.toLocalDate());
            }
            case "day": {
                return this.dayFormatter.format(fuzzyDate.toLocalDate());
            }
        }
        throw new IllegalArgumentException("Unknown fuzzyDateType = " + fuzzyDate.getDateType());
    }

    private String formatHalfYear(FuzzyDate fuzzyDate) {
        String key = this.getHalfYearPrefix() + fuzzyDate.getHalfYear();
        String value = this.dateBundle.getString(key);
        value = value.replace("%y", String.valueOf(fuzzyDate.getYear()));
        return value;
    }

    private String getHalfYearPrefix() {
        switch (this.formatStyle) {
            case SHORT: {
                return "halfyear_short_";
            }
            case MEDIUM: {
                return "halfyear_medium_";
            }
        }
        return "halfyear_long_";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FuzzyDateFormatter build(FormatStyle formatStyle, Locale locale) {
        String quarterPattern;
        String monthPattern;
        String key = locale.toString() + '|' + (Object)((Object)formatStyle);
        FuzzyDateFormatter fuzzyDateFormatter = internMap.get(key);
        if (fuzzyDateFormatter != null) {
            return fuzzyDateFormatter;
        }
        String dayPattern = DateUtils.getLocalizedPattern(formatStyle, locale);
        switch (formatStyle) {
            case SHORT: {
                if (dayPattern.indexOf("/") > 0) {
                    monthPattern = "MM/y";
                    quarterPattern = "qqq/y";
                    break;
                }
                monthPattern = "y-MM";
                quarterPattern = "y-qqq";
                break;
            }
            case MEDIUM: {
                monthPattern = "MMM y";
                quarterPattern = "QQQ y";
                break;
            }
            default: {
                monthPattern = "MMMM y";
                quarterPattern = "QQQQ y";
            }
        }
        fuzzyDateFormatter = new FuzzyDateFormatter(formatStyle, locale, dayPattern, monthPattern, quarterPattern);
        Map<String, FuzzyDateFormatter> map = internMap;
        synchronized (map) {
            internMap.put(key, fuzzyDateFormatter);
        }
        return fuzzyDateFormatter;
    }
}

