/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io.odtable;

import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.money.ExtendedCurrency;

public final class StyleKey {
    private final short styleFamily;
    private final String styleName;
    private final ExtendedCurrency currency;
    private final String pattern;

    private StyleKey(String parentStyleName) {
        this.styleFamily = 0;
        this.styleName = parentStyleName;
        this.currency = null;
        this.pattern = null;
    }

    private StyleKey(ExtendedCurrency currency, String parentStyleName) {
        this.styleFamily = (short)2;
        this.styleName = parentStyleName;
        this.currency = currency;
        this.pattern = null;
    }

    private StyleKey(String pattern, String parentStyleName) {
        this.styleFamily = 1;
        this.styleName = parentStyleName;
        this.currency = null;
        this.pattern = pattern;
    }

    public short getStyleFamliy() {
        return this.styleFamily;
    }

    public boolean isStandardStyle() {
        return this.styleFamily == 0;
    }

    public boolean isDateStyle() {
        return this.styleFamily == 1;
    }

    public boolean isCurrencyStyle() {
        return this.styleFamily == 2;
    }

    @Nullable
    public ExtendedCurrency getCurrency() {
        return this.currency;
    }

    @Nullable
    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    public String getParentStyleName() {
        return this.styleName;
    }

    public int hashCode() {
        int code = this.styleFamily;
        if (this.currency != null) {
            code += this.currency.hashCode();
        }
        if (this.styleName != null) {
            code += this.styleName.hashCode();
        }
        if (this.pattern != null) {
            code += this.pattern.hashCode();
        }
        return code;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        StyleKey otherStyleKey = (StyleKey)other;
        if (otherStyleKey.styleFamily != this.styleFamily) {
            return false;
        }
        if (otherStyleKey.currency == null) {
            if (this.currency != null) {
                return false;
            }
        } else {
            if (this.currency == null) {
                return false;
            }
            if (!otherStyleKey.currency.equals(this.currency)) {
                return false;
            }
        }
        if (otherStyleKey.pattern == null) {
            if (this.pattern != null) {
                return false;
            }
        } else {
            if (this.pattern == null) {
                return false;
            }
            if (!otherStyleKey.pattern.equals(this.pattern)) {
                return false;
            }
        }
        if (otherStyleKey.styleName == null) {
            return this.styleName == null;
        }
        if (this.styleName == null) {
            return false;
        }
        return otherStyleKey.styleName.equals(this.styleName);
    }

    public static StyleKey newStandardInstance(String parentStyleName) {
        return new StyleKey(parentStyleName);
    }

    public static StyleKey newIsoDateInstance(String parentStyleName) {
        return new StyleKey("y-MM-dd", parentStyleName);
    }

    public static StyleKey newDateInstance(String pattern) {
        return new StyleKey(pattern, null);
    }

    public static StyleKey newDateInstance(String pattern, String parentStyleName) {
        return new StyleKey(pattern, parentStyleName);
    }

    public static StyleKey newCurrencyInstance(ExtendedCurrency currency) {
        return StyleKey.newCurrencyInstance(currency, null);
    }

    public static StyleKey newCurrencyInstance(ExtendedCurrency currency, String parentStyleName) {
        return new StyleKey(currency, parentStyleName);
    }
}

