/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io.odtable;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import net.mapeadores.opendocument.io.odtable.OdColumnDef;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.StyleKey;
import net.mapeadores.util.money.ExtendedCurrency;

public class OdTableDefBuilder {
    private static final StyleKey STANDARD_KEY = StyleKey.newStandardInstance(null);
    private static final OdColumnDef STANDARD_COLUMNDEF = new InternalOdColumnDef(STANDARD_KEY, null);
    private final List<OdColumnDef> odColumnList = new ArrayList<OdColumnDef>();
    private final String tableName;

    public OdTableDefBuilder(String tableName) {
        this.tableName = tableName;
    }

    public OdTableDefBuilder addStandard() {
        this.odColumnList.add(STANDARD_COLUMNDEF);
        return this;
    }

    public OdTableDefBuilder addStandard(String customStyleName) {
        this.odColumnList.add(new InternalOdColumnDef(STANDARD_KEY, customStyleName));
        return this;
    }

    public OdTableDefBuilder addStandard(String customStyleName, String defaulCellStyleName) {
        this.odColumnList.add(new InternalOdColumnDef(StyleKey.newStandardInstance(defaulCellStyleName), customStyleName));
        return this;
    }

    public OdTableDefBuilder addStandards(int length) {
        for (int i = 0; i < length; ++i) {
            this.odColumnList.add(STANDARD_COLUMNDEF);
        }
        return this;
    }

    public OdTableDefBuilder addStandards(int length, String customStyleName) {
        InternalOdColumnDef columnDef = new InternalOdColumnDef(STANDARD_KEY, customStyleName);
        for (int i = 0; i < length; ++i) {
            this.odColumnList.add(columnDef);
        }
        return this;
    }

    public OdTableDefBuilder addStandards(int length, String customStyleName, String defaulCellStyleName) {
        InternalOdColumnDef columnDef = new InternalOdColumnDef(StyleKey.newStandardInstance(defaulCellStyleName), customStyleName);
        for (int i = 0; i < length; ++i) {
            this.odColumnList.add(columnDef);
        }
        return this;
    }

    public OdTableDefBuilder addDate() {
        this.addDate("y-MM-dd");
        return this;
    }

    public OdTableDefBuilder addDate(String pattern) {
        this.odColumnList.add(new InternalOdColumnDef(StyleKey.newDateInstance(pattern), null));
        return this;
    }

    public OdTableDefBuilder addCurrency(ExtendedCurrency currency) {
        this.odColumnList.add(new InternalOdColumnDef(StyleKey.newCurrencyInstance(currency), null));
        return this;
    }

    public OdTableDefBuilder add(OdColumnDef odColumnDef) {
        this.odColumnList.add(odColumnDef);
        return this;
    }

    public OdTableDef toOdTableDef() {
        OdColumnDef[] odColumnArray = this.odColumnList.toArray(new OdColumnDef[this.odColumnList.size()]);
        return new InternalOdTableDef(this.tableName, OdTableDefBuilder.wrap(odColumnArray));
    }

    public static OdTableDefBuilder init(String tableName) {
        return new OdTableDefBuilder(tableName);
    }

    public static OdTableDef buildStandard(String tableName, int colCount) {
        OdColumnDef[] odColumnArray = new OdColumnDef[colCount];
        for (int i = 0; i < colCount; ++i) {
            odColumnArray[i] = STANDARD_COLUMNDEF;
        }
        return new InternalOdTableDef(tableName, OdTableDefBuilder.wrap(odColumnArray));
    }

    public static List<OdColumnDef> wrap(OdColumnDef[] array) {
        return new OdColumnDefList(array);
    }

    private static class InternalOdColumnDef
    implements OdColumnDef {
        private final StyleKey styleKey;
        private final String customStyleName;

        private InternalOdColumnDef(StyleKey styleKey, String customStyleName) {
            this.styleKey = styleKey;
            this.customStyleName = customStyleName;
        }

        @Override
        public StyleKey getDefaultStyleKey() {
            return this.styleKey;
        }

        @Override
        public String getCustomStyleName() {
            return this.customStyleName;
        }
    }

    private static class InternalOdTableDef
    implements OdTableDef {
        private final String tableName;
        private final List<OdColumnDef> odColumnList;

        private InternalOdTableDef(String tableName, List<OdColumnDef> odColumnList) {
            this.tableName = tableName;
            this.odColumnList = odColumnList;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }

        @Override
        public List<OdColumnDef> getOdColumnDefList() {
            return this.odColumnList;
        }
    }

    private static class OdColumnDefList
    extends AbstractList<OdColumnDef>
    implements RandomAccess {
        private final OdColumnDef[] array;

        private OdColumnDefList(OdColumnDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public OdColumnDef get(int index) {
            return this.array[index];
        }
    }
}

