/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.css.parse;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.mapeadores.opendocument.css.parse.CssSource;

public class DistCssSource
implements CssSource {
    private final Class referenceClass;
    private final String path;

    public DistCssSource(Class referenceClass, String path) {
        if (referenceClass.getResource(path) == null) {
            throw new IllegalArgumentException("path does not exist: " + path);
        }
        this.referenceClass = referenceClass;
        this.path = path;
    }

    @Override
    public Reader getReader() throws IOException {
        InputStream inputStream = this.referenceClass.getResourceAsStream(this.path);
        return new InputStreamReader(inputStream, "UTF-8");
    }

    @Override
    public CssSource getImportCssSource(String url) {
        if (this.referenceClass.getResource(url) != null) {
            return new DistCssSource(this.referenceClass, url);
        }
        return null;
    }

    @Override
    public String getCssSourceURI() {
        return this.referenceClass.getPackage().getName() + "/" + this.path;
    }
}

