/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.css.output;

import java.io.IOException;
import java.util.Map;
import net.mapeadores.opendocument.css.output.StylesXMLWriter;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.opendocument.elements.ListStyleElement;
import net.mapeadores.opendocument.elements.StyleElement;

public final class StylesConversionEngine {
    private StylesConversionEngine() {
    }

    public static String toStyleXml(ElementMaps elementMaps) {
        StringBuilder buf = new StringBuilder();
        StylesXMLWriter stylesWriter = new StylesXMLWriter(buf, 0);
        try {
            stylesWriter.appendXMLDeclaration();
            stylesWriter.openStyleDocument();
            stylesWriter.openStyles();
            StylesConversionEngine.writeStyles(stylesWriter, elementMaps);
            stylesWriter.closeStyles();
            stylesWriter.closeStyleDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static String toAutomaticStylesXml(ElementMaps elementMaps) {
        StringBuilder buf = new StringBuilder();
        StylesXMLWriter stylesWriter = new StylesXMLWriter(buf, -999);
        try {
            stylesWriter.appendXMLDeclaration();
            stylesWriter.startOpenTag("office:automatic-styles");
            stylesWriter.appendNameSpaceAttributes();
            stylesWriter.endOpenTag();
            StylesConversionEngine.writeAutomaticStyles(stylesWriter, elementMaps);
            stylesWriter.closeTag("office:automatic-styles");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static void appendAllStyles(Appendable appendable, ElementMaps elementMaps) throws IOException {
        StylesXMLWriter stylesWriter = new StylesXMLWriter(appendable, 0);
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps);
    }

    public static void appendAutomaticStyles(Appendable appendable, ElementMaps elementMaps) throws IOException {
        StylesXMLWriter stylesWriter = new StylesXMLWriter(appendable, 0);
        StylesConversionEngine.writeAutomaticStyles(stylesWriter, elementMaps);
    }

    public static String insertAllStyles(String stylesXml, ElementMaps elementMaps, boolean includeH) {
        int index = stylesXml.indexOf("</office:styles>");
        if (index == -1) {
            return stylesXml;
        }
        String part1 = stylesXml.substring(0, index);
        String part2 = stylesXml.substring(index);
        StringBuilder buf = new StringBuilder(part1);
        StylesXMLWriter stylesWriter = new StylesXMLWriter(buf, 0);
        try {
            if (includeH) {
                for (StyleElement styleElement : elementMaps.getHMap().values()) {
                    if (part1.contains("style:name=\"" + styleElement.getStyleName() + "\"")) continue;
                    stylesWriter.addStyleElement(styleElement);
                }
            }
            StylesConversionEngine.insertStyles(part1, stylesWriter, elementMaps, "paragraph");
            StylesConversionEngine.insertStyles(part1, stylesWriter, elementMaps, "text");
            StylesConversionEngine.insertStyles(part1, stylesWriter, elementMaps, "table");
            StylesConversionEngine.insertStyles(part1, stylesWriter, elementMaps, "table-column");
            StylesConversionEngine.insertStyles(part1, stylesWriter, elementMaps, "table-cell");
            StylesConversionEngine.insertStyles(part1, stylesWriter, elementMaps, "table-row");
            StylesConversionEngine.insertStyles(part1, stylesWriter, elementMaps, "graphic");
            Map<String, ListStyleElement> map = elementMaps.getListStyleMap();
            for (ListStyleElement listStyleElement : map.values()) {
                if (part1.contains("style:name=\"" + listStyleElement.getStyleName() + "\"")) continue;
                stylesWriter.addListStyleElement(listStyleElement);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        buf.append(part2);
        return buf.toString();
    }

    private static void writeAutomaticStyles(StylesXMLWriter stylesWriter, ElementMaps elementMaps) throws IOException {
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps, "table");
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps, "table-column");
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps, "table-cell");
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps, "table-row");
    }

    private static void writeStyles(StylesXMLWriter stylesWriter, ElementMaps elementMaps) throws IOException {
        for (StyleElement styleElement : elementMaps.getHMap().values()) {
            stylesWriter.addStyleElement(styleElement);
        }
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps, "paragraph");
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps, "text");
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps, "table");
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps, "table-column");
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps, "table-cell");
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps, "table-row");
        StylesConversionEngine.writeStyles(stylesWriter, elementMaps, "graphic");
        Map<String, ListStyleElement> map = elementMaps.getListStyleMap();
        for (ListStyleElement listStyleElement : map.values()) {
            stylesWriter.addListStyleElement(listStyleElement);
        }
    }

    private static void writeStyles(StylesXMLWriter stylesWriter, ElementMaps elementMaps, String family) throws IOException {
        Map<String, StyleElement> map = elementMaps.getFamilyMap(family);
        if (map == null || map.isEmpty()) {
            return;
        }
        for (StyleElement styleElement : map.values()) {
            stylesWriter.addStyleElement(styleElement);
        }
    }

    private static void insertStyles(String text, StylesXMLWriter stylesWriter, ElementMaps elementMaps, String family) throws IOException {
        Map<String, StyleElement> map = elementMaps.getFamilyMap(family);
        if (map == null || map.isEmpty()) {
            return;
        }
        for (StyleElement styleElement : map.values()) {
            if (text.contains("style:name=\"" + styleElement.getStyleName() + "\"")) continue;
            stylesWriter.addStyleElement(styleElement);
        }
    }
}

