/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.storage;

import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class ThesaurusTreeXMLPart
extends XMLPart {
    public ThesaurusTreeXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void appendThesaurus(Thesaurus thesaurus, Predicate<SubsetItem> predicate) throws IOException {
        this.openTag("thesaurus-tree");
        for (Motcle motcle : thesaurus.getFirstLevelList()) {
            this.appendMotcle(motcle, predicate);
        }
        this.closeTag("thesaurus-tree");
    }

    private void appendMotcle(Motcle motcle, Predicate<SubsetItem> predicate) throws IOException {
        List<Motcle> children;
        String status;
        if (predicate != null && !predicate.test(motcle)) {
            return;
        }
        this.startOpenTag("motcle");
        this.addAttribute("id", motcle.getId());
        String idalpha = motcle.getIdalpha();
        if (idalpha != null) {
            this.addAttribute("idalpha", idalpha);
        }
        if (!(status = motcle.getStatus()).equals("active")) {
            this.addAttribute("status", status);
        }
        if ((children = motcle.getChildList()).isEmpty()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            for (Motcle child : children) {
                this.appendMotcle(child, predicate);
            }
            this.closeTag("motcle");
        }
    }
}

