/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.storage;

import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.CountryItem;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.EmailItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.fiche.ImageItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.LinkItem;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.utils.SphereUtils;
import net.fichotheque.xml.storage.FicheBlockStorageXMLPart;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class FicheItemStorageXMLPart
extends XMLPart {
    private final FicheBlockStorageXMLPart ficheBlockStorageXMLPart;

    public FicheItemStorageXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
        this.ficheBlockStorageXMLPart = new FicheBlockStorageXMLPart(xmlWriter);
    }

    public void addFicheItems(FicheItems ficheItems) throws IOException {
        int size = ficheItems.size();
        for (int i = 0; i < size; ++i) {
            this.addFicheItem((FicheItem)ficheItems.get(i), null);
        }
    }

    public void addFicheItems(FicheItems ficheItems, Object fieldOptionObject) throws IOException {
        int size = ficheItems.size();
        for (int i = 0; i < size; ++i) {
            this.addFicheItem((FicheItem)ficheItems.get(i), fieldOptionObject);
        }
    }

    public void addFicheItem(FicheItem ficheItem) throws IOException {
        this.addFicheItem(ficheItem, null);
    }

    public void addFicheItem(FicheItem ficheItem, Object fieldOptionObject) throws IOException {
        if (ficheItem instanceof Item) {
            this.addItem((Item)ficheItem);
        } else if (ficheItem instanceof PersonItem) {
            this.addPerson((PersonItem)ficheItem);
        } else if (ficheItem instanceof DateItem) {
            this.addDate((DateItem)ficheItem, fieldOptionObject);
        } else if (ficheItem instanceof LanguageItem) {
            this.addLanguage((LanguageItem)ficheItem);
        } else if (ficheItem instanceof CountryItem) {
            this.addCountry((CountryItem)ficheItem);
        } else if (ficheItem instanceof LinkItem) {
            this.addLink((LinkItem)ficheItem, fieldOptionObject);
        } else if (ficheItem instanceof EmailItem) {
            this.addEmail((EmailItem)ficheItem);
        } else if (ficheItem instanceof AmountItem) {
            this.addAmount((AmountItem)ficheItem, fieldOptionObject);
        } else if (ficheItem instanceof NumberItem) {
            this.addNumber((NumberItem)ficheItem);
        } else if (ficheItem instanceof GeopointItem) {
            this.addGeopoint((GeopointItem)ficheItem);
        } else if (ficheItem instanceof ParaItem) {
            this.addPara((ParaItem)ficheItem);
        } else if (ficheItem instanceof ImageItem) {
            this.addImage((ImageItem)ficheItem, fieldOptionObject);
        } else {
            throw new ClassCastException("unknown instance of FicheItem = " + ficheItem.getClass().getName());
        }
    }

    public void addItem(Item item) throws IOException {
        this.addSimpleElement("item", item.getValue());
    }

    public void addEmail(EmailItem emailItem) throws IOException {
        EmailCore emailCore = emailItem.getEmailCore();
        String addrSpec = emailCore.getAddrSpec();
        this.startOpenTag("courriel");
        this.addAttribute("addr-spec", addrSpec);
        String realName = emailCore.getRealName();
        if (realName.length() > 0) {
            this.addAttribute("real-name", realName);
        }
        this.closeEmptyTag();
    }

    public void addDate(DateItem dateItem, Object fieldOptionObject) throws IOException {
        FuzzyDate date = dateItem.getDate();
        this.startOpenTag("datation");
        this.addAttribute("a", String.valueOf(date.getYear()));
        switch (date.getDateType()) {
            case "halfyear": {
                this.addAttribute("type", "s");
                this.addAttribute("s", String.valueOf(date.getHalfYear()));
                break;
            }
            case "quarter": {
                this.addAttribute("type", "t");
                this.addAttribute("t", String.valueOf(date.getQuarter()));
                break;
            }
            case "month": {
                this.addAttribute("type", "m");
                this.addAttribute("m", String.valueOf(date.getMonth()));
                break;
            }
            case "day": {
                this.addAttribute("type", "j");
                this.addAttribute("m", String.valueOf(date.getMonth()));
                this.addAttribute("j", String.valueOf(date.getDay()));
                break;
            }
            default: {
                this.addAttribute("type", "a");
            }
        }
        this.closeEmptyTag();
    }

    public void addLanguage(LanguageItem languageItem) throws IOException {
        String code = languageItem.getLang().toString();
        this.startOpenTag("langue");
        this.addAttribute("lang", code);
        this.closeEmptyTag();
    }

    public void addNumber(NumberItem numberItem) throws IOException {
        this.startOpenTag("nombre");
        Decimal decimal = numberItem.getDecimal();
        this.addDecimalAttributes(decimal);
        this.closeEmptyTag();
    }

    public void addGeopoint(GeopointItem geopointItem) throws IOException {
        this.startOpenTag("geopoint");
        DegreDecimal latitude = geopointItem.getLatitude();
        DegreDecimal longitude = geopointItem.getLongitude();
        this.addAttribute("lat", latitude.toString());
        this.addAttribute("lon", longitude.toString());
        this.closeEmptyTag();
    }

    public void addAmount(AmountItem amountItem, Object fieldOptionObject) throws IOException {
        this.startOpenTag("montant");
        Decimal decimal = amountItem.getDecimal();
        this.addDecimalAttributes(decimal);
        this.addAttribute("cur", amountItem.getCurrency().getCurrencyCode());
        this.closeEmptyTag();
    }

    private void addDecimalAttributes(Decimal decimal) throws IOException {
        String partieEntiere = decimal.getPartieEntiereString();
        String partieDecimale = decimal.getPartieDecimaleString();
        String val = partieDecimale.length() != 0 ? partieEntiere + "." + partieDecimale : partieEntiere;
        this.addAttribute("val", val);
    }

    public void addLink(LinkItem linkItem, Object fieldOptionObject) throws IOException {
        this.startOpenTag("link");
        this.addAttribute("href", linkItem.getHref());
        if (linkItem.hasHrefOnly()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            this.addSimpleElement("title", linkItem.getTitle());
            this.addSimpleElement("comment", linkItem.getComment());
            this.closeTag("link");
        }
    }

    public void addImage(ImageItem imageItem, Object fieldOptionObject) throws IOException {
        this.startOpenTag("image");
        this.addAttribute("src", imageItem.getSrc());
        if (imageItem.hasSrcOnly()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            this.addSimpleElement("alt", imageItem.getAlt());
            this.addSimpleElement("title", imageItem.getTitle());
            this.closeTag("image");
        }
    }

    public void addCountry(CountryItem countryItem) throws IOException {
        this.startOpenTag("pays");
        this.addAttribute("country", countryItem.getCountry().toString());
        this.closeEmptyTag();
    }

    public void addPerson(PersonItem personItem) throws IOException {
        this.startOpenTag("personne");
        String redacteurGlobalId = personItem.getRedacteurGlobalId();
        if (redacteurGlobalId != null) {
            try {
                SubsetKey sphereKey = SphereUtils.getSubsetKey(redacteurGlobalId);
                int id = SphereUtils.getId(redacteurGlobalId);
                this.addAttribute("sphere", sphereKey.getSubsetName());
                this.addAttribute("id", String.valueOf(id));
                this.closeEmptyTag();
            }
            catch (ParseException pe) {
                this.closeEmptyTag();
            }
        } else {
            this.endOpenTag();
            this.addPersonCore(personItem.getPersonCore());
            this.addSimpleElement("organism", personItem.getOrganism());
            this.closeTag("personne");
        }
    }

    private void addPersonCore(PersonCore personCore) throws IOException {
        String surname = personCore.getSurname();
        boolean surnameFirst = personCore.isSurnameFirst();
        if (surname.length() > 0) {
            this.startOpenTag("surname");
            if (surnameFirst) {
                this.addAttribute("surname-first", "true");
            }
            this.endOpenTag();
            this.addText(surname);
            this.closeTag("surname", false);
        }
        this.addSimpleElement("forename", personCore.getForename());
        this.addSimpleElement("nonlatin", personCore.getNonlatin());
    }

    public void addPara(ParaItem paraItem) throws IOException {
        this.startOpenTag("para");
        this.endOpenTag();
        this.ficheBlockStorageXMLPart.addTextContent(paraItem);
        this.closeTag("para", false);
    }
}

