/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.storage;

import java.io.IOException;
import net.fichotheque.album.AlbumConstants;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.album.metadata.AlbumMetadata;
import net.fichotheque.utils.FichothequeXMLUtils;
import net.mapeadores.util.awt.ResizeInfo;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class AlbumMetadataXMLPart
extends XMLPart {
    public AlbumMetadataXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void appendAlbumMetadata(AlbumMetadata albumMetadata) throws IOException {
        this.openTag("album-metadata");
        FichothequeXMLUtils.write(albumMetadata, this);
        for (AlbumDim albumDim : albumMetadata.getAlbumDimList()) {
            this.appendAlbumDim(albumDim);
        }
        this.closeTag("album-metadata");
    }

    private void appendAlbumDim(AlbumDim albumDim) throws IOException {
        String type = albumDim.getDimType();
        this.startOpenTag("album-dim");
        this.addAttribute("name", albumDim.getName());
        this.addAttribute("type", type);
        ResizeInfo resizeInfo = albumDim.getResizeInfo();
        if (AlbumConstants.needWidth(type)) {
            this.addAttribute("width", resizeInfo.getWidth());
        }
        if (AlbumConstants.needHeight(type)) {
            this.addAttribute("height", resizeInfo.getHeight());
        }
        this.endOpenTag();
        this.closeTag("album-dim");
    }
}

