/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.importation;

import java.io.IOException;
import java.util.List;
import net.fichotheque.corpus.FicheChange;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.importation.CorpusImport;
import net.fichotheque.xml.importation.TiesImportXMLPart;
import net.fichotheque.xml.storage.FicheStorageXMLPart;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class CorpusImportXMLPart
extends XMLPart {
    private final TiesImportXMLPart tiesImportXMLPart;
    private final FicheStorageXMLPart ficheStorageXMLPart;

    public CorpusImportXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
        this.tiesImportXMLPart = new TiesImportXMLPart(xmlWriter);
        this.ficheStorageXMLPart = new FicheStorageXMLPart(xmlWriter);
    }

    public void addCorpusImport(CorpusImport corpusImport) throws IOException {
        String type = corpusImport.getType();
        this.startOpenTag("corpusimport");
        this.addAttribute("corpus", corpusImport.getCorpus().getSubsetName());
        this.addAttribute("type", type);
        this.endOpenTag();
        for (CorpusImport.FicheImport ficheImport : corpusImport.getFicheImportList()) {
            if (ficheImport instanceof CorpusImport.EditFicheImport) {
                this.addEditFicheImport((CorpusImport.EditFicheImport)ficheImport);
                continue;
            }
            this.addFicheImport(ficheImport);
        }
        this.closeTag("corpusimport");
    }

    private void addFicheImport(CorpusImport.FicheImport ficheImport) throws IOException {
        this.startOpenTag("ficheimport");
        this.addAttribute("id", ficheImport.getFicheId());
        this.closeEmptyTag();
    }

    public void addEditFicheImport(CorpusImport.EditFicheImport ficheImport) throws IOException {
        this.startOpenTag("ficheimport");
        int id = ficheImport.getFicheId();
        if (id > 0) {
            this.addAttribute("id", id);
        }
        this.endOpenTag();
        this.addFicheChange(ficheImport.getFicheChange());
        this.addAttributeChange(ficheImport.getAttributeChange());
        this.tiesImportXMLPart.addTiesImport(ficheImport.getTiesImport());
        this.addCreationDate(ficheImport.getCreationDate());
        this.closeTag("ficheimport");
    }

    private void addFicheChange(FicheChange ficheChange) throws IOException {
        List<FieldKey> fieldKeyList;
        FicheAPI ficheAPI = ficheChange.getFicheAPI();
        if (ficheAPI != null) {
            this.ficheStorageXMLPart.appendFiche(ficheAPI);
        }
        if (!(fieldKeyList = ficheChange.getRemovedList()).isEmpty()) {
            this.openTag("removed");
            for (FieldKey fieldKey : fieldKeyList) {
                this.addSimpleElement("key", fieldKey.getKeyString());
            }
            this.closeTag("removed");
        }
    }

    private void addAttributeChange(AttributeChange attributeChange) throws IOException {
        AttributeUtils.addAttributes(this, attributeChange.getChangedAttributes());
        for (AttributeKey attributeKey : attributeChange.getRemovedAttributeKeyList()) {
            this.startOpenTag("attr");
            this.addAttribute("ns", attributeKey.getNameSpace());
            this.addAttribute("key", attributeKey.getLocalKey());
            this.closeEmptyTag();
        }
    }

    private void addCreationDate(FuzzyDate creationDate) throws IOException {
        if (creationDate != null) {
            this.startOpenTag("chrono");
            this.addAttribute("creation", creationDate.toISOString());
            this.closeEmptyTag();
        }
    }
}

