/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.io.IOException;
import net.fichotheque.album.Illustration;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.def.IllustrationFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.run.IllustrationExtractInfo;
import net.fichotheque.junction.Junction;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.fichotheque.xml.extraction.TagNames;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class IllustrationXMLPart
extends XMLPart {
    private final ExtractParameters extractParameters;
    private final TagNames tagNames;

    public IllustrationXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters) {
        super(xmlWriter);
        this.extractParameters = extractParameters;
        this.tagNames = new TagNames(extractParameters.getExtractVersion());
    }

    public void addIllustration(IllustrationExtractInfo illustrationExtractInfo) throws IOException {
        IllustrationFilter illustrationFilter = illustrationExtractInfo.getIllustrationFilter();
        Illustration illustration = illustrationExtractInfo.getIllustration();
        String tagName = this.getTagName(illustrationFilter.getTagNameInfo());
        Junction junction = illustrationExtractInfo.getJunction();
        if (tagName != null) {
            this.startOpenTag(tagName);
            this.addAttribute("album", illustration.getSubsetName());
            this.addAttribute("id", illustration.getId());
            this.addAttribute("format", illustration.getFormatType());
            int width = illustration.getOriginalWidth();
            int height = illustration.getOriginalHeight();
            this.addAttribute("width", width);
            this.addAttribute("height", height);
            this.addAttribute("ratio", String.valueOf((float)width / (float)height));
            int weight = ExtractionXMLUtils.getMainWeight(junction);
            if (weight > 0) {
                this.addAttribute(this.tagNames.getWeightAttributeName(), weight);
            }
            if (junction == null) {
                this.closeEmptyTag();
            } else {
                this.endOpenTag();
                ExtractionXMLUtils.writeJunction(this, junction, this.tagNames);
                this.closeTag(tagName);
            }
        }
    }

    private String getTagName(TagNameInfo tagNameInfo) {
        switch (tagNameInfo.getType()) {
            case 3: {
                return tagNameInfo.getCustomTagName();
            }
            case 2: {
                return null;
            }
        }
        return "illustration";
    }
}

