/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.io.IOException;
import java.util.List;
import net.fichotheque.album.Album;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.def.AlbumExtractDef;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.extraction.run.AlbumExtractResult;
import net.fichotheque.extraction.run.IllustrationExtractInfo;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.fichotheque.xml.extraction.IllustrationXMLPart;
import net.fichotheque.xml.extraction.TagNames;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class AlbumExtractXMLPart
extends XMLPart {
    private final ExtractParameters extractParameters;
    private final int extractVersion;
    private final IllustrationXMLPart illustrationXMLPart;
    private final TagNames tagNames;

    public AlbumExtractXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters) {
        super(xmlWriter);
        this.extractParameters = extractParameters;
        this.extractVersion = extractParameters.getExtractVersion();
        this.illustrationXMLPart = new IllustrationXMLPart(xmlWriter, extractParameters);
        this.tagNames = new TagNames(this.extractVersion);
    }

    public void addAlbumExtract(AlbumExtractResult albumExtractResult) throws IOException {
        this.addAlbumExtract(albumExtractResult, null);
    }

    public void addAlbumExtract(AlbumExtractResult albumExtractResult, FilterUnit filterUnit) throws IOException {
        AlbumExtractDef albumExtractDef = albumExtractResult.getAlbumExtractDef();
        List<AlbumExtractResult.Entry> entryList = albumExtractResult.getEntryList();
        if (entryList.isEmpty() && this.extractParameters.hideIfEmpty(filterUnit)) {
            return;
        }
        String tagName = this.getTagName(albumExtractDef.getTagNameInfo());
        boolean withTag = tagName != null;
        String name = albumExtractDef.getName();
        if (name != null) {
            if (withTag) {
                this.startOpenTag(tagName);
                this.addAttribute("name", name);
                if (this.extractVersion == 1) {
                    this.addAttribute("extrait-name", name);
                }
                ExtractionXMLUtils.addFilterParameters((XMLWriter)this, filterUnit);
                this.endOpenTag();
            }
            for (AlbumExtractResult.Entry entry : entryList) {
                for (IllustrationExtractInfo illustrationExtractInfo : entry.getIllustrationExtractInfoList()) {
                    this.illustrationXMLPart.addIllustration(illustrationExtractInfo);
                }
            }
            if (withTag) {
                this.closeTag(tagName);
            }
        } else {
            for (AlbumExtractResult.Entry entry : entryList) {
                Album album = entry.getAlbum();
                if (withTag) {
                    this.startOpenTag(tagName);
                    this.addAttribute("album", album.getSubsetName());
                    ExtractionXMLUtils.addFilterParameters((XMLWriter)this, filterUnit);
                    this.endOpenTag();
                }
                for (IllustrationExtractInfo illustrationExtractInfo : entry.getIllustrationExtractInfoList()) {
                    this.illustrationXMLPart.addIllustration(illustrationExtractInfo);
                }
                if (!withTag) continue;
                this.closeTag(tagName);
            }
        }
    }

    private String getTagName(TagNameInfo tagNameInfo) {
        switch (tagNameInfo.getType()) {
            case 3: {
                return tagNameInfo.getCustomTagName();
            }
            case 2: {
                return null;
            }
        }
        return this.tagNames.getSubsetTagName((short)5);
    }
}

