/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Junctions;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FicheSelector;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.SelectionContext;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.FicheSelectorBuilder;

public final class FicheConditionPredicateFactory {
    private static final Test ALWAYS_TEST = new ConstantTest(true);

    private FicheConditionPredicateFactory() {
    }

    public static Predicate<SubsetItem> newInstance(SelectionContext selectionContext, FicheCondition ficheCondition) {
        ArrayList<Test> testList = new ArrayList<Test>();
        for (FicheCondition.Entry entry : ficheCondition.getEntryList()) {
            Test test = FicheConditionPredicateFactory.toTest(selectionContext, entry.getFicheQuery(), entry.getJunctionCondition(), entry.includeSatellites());
            if (test == null) continue;
            testList.add(test);
        }
        int size = testList.size();
        Test[] testArray = size == 0 ? new Test[]{ALWAYS_TEST} : testList.toArray(new Test[size]);
        return new ResultPredicate(ficheCondition.getLogicalOperator(), testArray);
    }

    private static Test toTest(SelectionContext selectionContext, FicheQuery ficheQuery, JunctionCondition junctionCondition, boolean includeSatellites) {
        boolean invert = false;
        if (junctionCondition == null && ficheQuery.isOnlyCorpusCondition()) {
            if (ficheQuery.isEmpty()) {
                return null;
            }
            return new CorpusListTest(invert, selectionContext, ficheQuery, includeSatellites);
        }
        return new FicheSelectorTest(invert, selectionContext, ficheQuery, junctionCondition, includeSatellites);
    }

    private static Set<SubsetKey> toSubsetKeySet(Corpus[] corpusArray) {
        HashSet<SubsetKey> subsetKeySet = new HashSet<SubsetKey>();
        for (Corpus corpus : corpusArray) {
            subsetKeySet.add(corpus.getSubsetKey());
        }
        return subsetKeySet;
    }

    private static abstract class Test {
        private final boolean invert;

        protected Test(boolean invert) {
            this.invert = invert;
        }

        public boolean isSelected(SubsetItem subsetItem) {
            boolean test = this.test(subsetItem);
            if (this.invert) {
                return !test;
            }
            return test;
        }

        protected abstract boolean test(SubsetItem var1);
    }

    private static class ResultPredicate
    implements Predicate<SubsetItem> {
        private final boolean isOr;
        private final Test[] testArray;

        private ResultPredicate(String logicalOperator, Test[] testArray) {
            this.isOr = logicalOperator.equals("or");
            this.testArray = testArray;
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            if (this.isOr) {
                for (Test test : this.testArray) {
                    if (!test.isSelected(subsetItem)) continue;
                    return true;
                }
                return false;
            }
            for (Test test : this.testArray) {
                if (test.isSelected(subsetItem)) continue;
                return false;
            }
            return true;
        }
    }

    private static class CorpusListTest
    extends Test {
        private final Fichotheque fichotheque;
        private final Corpus[] corpusArray;
        private final boolean withSatelliteTest;
        private final Predicate<FicheMeta> fichePredicate;
        private final Set<SubsetKey> subsetKeySet;

        private CorpusListTest(boolean invert, SelectionContext selectionContext, FicheQuery ficheQuery, boolean includeSatellites) {
            super(invert);
            this.fichotheque = selectionContext.getFichotheque();
            this.corpusArray = SelectionUtils.toCorpusArray(this.fichotheque, ficheQuery, selectionContext.getSubsetAccessPredicate());
            this.withSatelliteTest = includeSatellites;
            this.fichePredicate = selectionContext.getFichePredicate();
            this.subsetKeySet = this.withSatelliteTest ? FicheConditionPredicateFactory.toSubsetKeySet(this.corpusArray) : null;
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            if (this.withSatelliteTest) {
                for (Corpus corpus : subsetItem.getSubset().getSatelliteCorpusList()) {
                    FicheMeta ficheMeta;
                    if (!this.subsetKeySet.contains(corpus.getSubsetKey()) || (ficheMeta = corpus.getFicheMetaById(subsetItem.getId())) == null || !this.fichePredicate.test(ficheMeta)) continue;
                    return true;
                }
            }
            for (Corpus corpus : this.corpusArray) {
                Junctions junctions = this.fichotheque.getJunctions(subsetItem, corpus);
                if (junctions.isEmpty()) continue;
                for (Junctions.Entry entry : junctions.getEntryList()) {
                    FicheMeta ficheMeta = (FicheMeta)entry.getSubsetItem();
                    if (!this.fichePredicate.test(ficheMeta)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class FicheSelectorTest
    extends Test {
        private final Fichotheque fichotheque;
        private final Corpus[] corpusArray;
        private final boolean withSatelliteTest;
        private final Set<SubsetKey> subsetKeySet;
        private final FicheSelector ficheSelector;
        private final boolean withJunctionCondition;

        private FicheSelectorTest(boolean invert, SelectionContext selectionContext, FicheQuery ficheQuery, JunctionCondition junctionCondition, boolean includeSatellites) {
            super(invert);
            this.fichotheque = selectionContext.getFichotheque();
            this.corpusArray = SelectionUtils.toCorpusArray(this.fichotheque, ficheQuery, selectionContext.getSubsetAccessPredicate());
            this.withSatelliteTest = includeSatellites;
            this.subsetKeySet = this.withSatelliteTest ? FicheConditionPredicateFactory.toSubsetKeySet(this.corpusArray) : null;
            this.ficheSelector = FicheSelectorBuilder.init(selectionContext).add(ficheQuery, junctionCondition).toFicheSelector();
            this.withJunctionCondition = junctionCondition != null;
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            if (this.withSatelliteTest) {
                for (Corpus corpus : subsetItem.getSubset().getSatelliteCorpusList()) {
                    FicheMeta satelliteFicheMeta;
                    if (!this.subsetKeySet.contains(corpus.getSubsetKey()) || (satelliteFicheMeta = corpus.getFicheMetaById(subsetItem.getId())) == null || !this.ficheSelector.test(satelliteFicheMeta)) continue;
                    return true;
                }
            }
            for (Corpus corpus : this.corpusArray) {
                Junctions junctions = this.fichotheque.getJunctions(subsetItem, corpus);
                for (Junctions.Entry entry : junctions.getEntryList()) {
                    FicheMeta ficheMeta = (FicheMeta)entry.getSubsetItem();
                    if (!(!this.withJunctionCondition ? this.ficheSelector.test(ficheMeta) : this.ficheSelector.isSelected(ficheMeta, entry.getJunction()) != null)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class ConstantTest
    extends Test {
        private ConstantTest(boolean constant) {
            super(constant);
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            return true;
        }
    }
}

