/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.pointeurs;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.junction.Junctions;
import net.fichotheque.pointeurs.MotclePointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.utils.JunctionUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.fichotheque.utils.pointeurs.AbstractPointeur;
import net.mapeadores.util.text.Label;

class MotclePointeurImpl
extends AbstractPointeur
implements MotclePointeur {
    private final Thesaurus thesaurus;
    private final Map<SubsetKey, DescendantAxisBuffer> descendantAxisBufferMap = new HashMap<SubsetKey, DescendantAxisBuffer>();
    private Motcle currentMotcle;

    public MotclePointeurImpl(Thesaurus thesaurus) {
        super(thesaurus);
        this.thesaurus = thesaurus;
    }

    @Override
    protected void initCurrentSubsetItem(SubsetItem subsetItem) {
        Motcle motcle;
        this.currentMotcle = motcle = (Motcle)subsetItem;
        for (DescendantAxisBuffer descendantAxisBuffer : this.descendantAxisBufferMap.values()) {
            descendantAxisBuffer.setCurrentMotcle(motcle);
        }
    }

    @Override
    public Junctions getDescendantAxisJunctionList(Subset subset) {
        SubsetKey subsetKey = subset.getSubsetKey();
        DescendantAxisBuffer descendantAxisBuffer = this.descendantAxisBufferMap.get(subsetKey);
        if (descendantAxisBuffer == null) {
            descendantAxisBuffer = new DescendantAxisBuffer(subset);
            descendantAxisBuffer.setCurrentMotcle(this.currentMotcle);
            this.descendantAxisBufferMap.put(subsetKey, descendantAxisBuffer);
        }
        return descendantAxisBuffer.getJunctionList();
    }

    @Override
    public Object getFieldValue(ThesaurusFieldKey thesaurusFieldKey) {
        if (this.currentMotcle == null) {
            return null;
        }
        short category = thesaurusFieldKey.getCategory();
        if (category == 0) {
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.ID)) {
                return this.currentMotcle.getId();
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.IDALPHA)) {
                return this.currentMotcle.getIdalpha();
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.STATUS)) {
                return this.currentMotcle.getStatus();
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.PARENT_ID)) {
                Motcle parent = this.currentMotcle.getParent();
                if (parent == null) {
                    return null;
                }
                return parent.getId();
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.PARENT_IDALPHA)) {
                Motcle parent = this.currentMotcle.getParent();
                if (parent == null) {
                    return null;
                }
                return parent.getIdalpha();
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.POSITION_LOCAL)) {
                return this.currentMotcle.getChildIndex() + 1;
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.POSITION_GLOBAL)) {
                return ThesaurusUtils.getGlobalPosition(this.currentMotcle);
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.LEVEL)) {
                return this.currentMotcle.getLevel();
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.THIS)) {
                return this.currentMotcle;
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.BABELIENLANG)) {
                if (this.thesaurus.isBabelienType()) {
                    return this.currentMotcle.getBabelienLabel().getLang();
                }
                return null;
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.BABELIENLABEL)) {
                if (this.thesaurus.isBabelienType()) {
                    return this.currentMotcle.getBabelienLabel().getLabelString();
                }
                return null;
            }
            throw new IllegalArgumentException("Unkwnon special thesaurusFieldKey : " + thesaurusFieldKey.toString());
        }
        if (category == 1) {
            Label label = this.currentMotcle.getLabels().getLangPartCheckedLabel(thesaurusFieldKey.getLang());
            if (label != null) {
                return label.getLabelString();
            }
            return null;
        }
        throw new IllegalArgumentException("Unkwnon thesaurusFieldKey : " + thesaurusFieldKey.toString());
    }

    private static class DescendantAxisBuffer {
        private final Subset otherSubset;
        private Junctions currentJunctions;
        private int currentMotcleid;

        private DescendantAxisBuffer(Subset otherSubset) {
            this.otherSubset = otherSubset;
            this.initToNull();
        }

        private void setCurrentMotcle(Motcle motcle) {
            if (motcle == null) {
                if (this.currentMotcleid != -1) {
                    this.initToNull();
                }
            } else {
                int newMotcleid = motcle.getId();
                if (newMotcleid != this.currentMotcleid) {
                    this.currentMotcleid = newMotcleid;
                    DescendantJunctionsBuilder builder = new DescendantJunctionsBuilder(this.otherSubset, this.otherSubset.getFichotheque().getJunctions(motcle, this.otherSubset));
                    builder.addDescendant(motcle.getChildList());
                    this.currentJunctions = builder.toJunctions();
                }
            }
        }

        private Junctions getJunctionList() {
            return this.currentJunctions;
        }

        private void initToNull() {
            this.currentMotcleid = -1;
            this.currentJunctions = JunctionUtils.EMPTY_JUNCTIONS;
        }
    }

    private static class DescendantJunctionsBuilder {
        private final Map<Integer, Junctions.Entry> entryMap = new LinkedHashMap<Integer, Junctions.Entry>();
        private final Subset otherSubset;

        private DescendantJunctionsBuilder(Subset otherSubset, Junctions junctions) {
            this.otherSubset = otherSubset;
            for (Junctions.Entry entry : junctions.getEntryList()) {
                this.entryMap.put(entry.getSubsetItem().getId(), entry);
            }
        }

        private void addDescendant(List<Motcle> motcleList) {
            for (Motcle motcle : motcleList) {
                Junctions junctions = this.otherSubset.getFichotheque().getJunctions(motcle, this.otherSubset);
                for (Junctions.Entry entry : junctions.getEntryList()) {
                    SubsetItem subsetItem = entry.getSubsetItem();
                    int id = subsetItem.getId();
                    if (this.entryMap.containsKey(id)) continue;
                    this.entryMap.put(id, entry);
                }
                this.addDescendant(motcle.getChildList());
            }
        }

        private Junctions toJunctions() {
            return JunctionUtils.toJunctions(this.entryMap.values());
        }
    }
}

