/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.text.ParseException;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.sphere.LoginKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.utils.CorpusMetadataUtils;

public final class SphereUtils {
    private SphereUtils() {
    }

    public static boolean testLogin(String login) {
        try {
            LoginKey.checkLogin(login);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static boolean testRedacteurs(Corpus corpus, Redacteur redacteur) {
        String globalId = redacteur.getGlobalId();
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            if (!ficheMeta.belongsTo(globalId)) continue;
            return true;
        }
        return false;
    }

    public static boolean testRedacteursAndFields(Corpus corpus, Redacteur redacteur, List<CorpusField> personneFieldList) {
        boolean redacTest = SphereUtils.testRedacteurs(corpus, redacteur);
        if (redacTest) {
            return true;
        }
        if (personneFieldList.isEmpty()) {
            return false;
        }
        FieldKey[] fieldKeyArray = CorpusMetadataUtils.toFieldKeyArray(personneFieldList);
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            FicheAPI fiche = corpus.getFicheAPI(ficheMeta, false);
            block5: for (FieldKey fieldKey : fieldKeyArray) {
                Object value = fiche.getValue(fieldKey);
                if (value == null) continue;
                switch (fieldKey.getCategory()) {
                    case 1: {
                        boolean here = SphereUtils.testFicheItem(redacteur, (FicheItem)value);
                        if (!here) continue block5;
                        return true;
                    }
                    case 2: {
                        for (FicheItem ficheItem : (FicheItems)value) {
                            boolean here = SphereUtils.testFicheItem(redacteur, ficheItem);
                            if (!here) continue;
                            return true;
                        }
                        continue block5;
                    }
                }
            }
        }
        return false;
    }

    public static boolean testFicheItem(Redacteur redacteur, FicheItem ficheItem) {
        if (!(ficheItem instanceof PersonItem)) {
            return false;
        }
        String redacteurGlobalId = ((PersonItem)ficheItem).getRedacteurGlobalId();
        if (redacteurGlobalId != null) {
            return redacteurGlobalId.equals(redacteur.getGlobalId());
        }
        return false;
    }

    public static boolean testGlobalId(String userGlobalId) {
        try {
            SphereUtils.getSubsetKey(userGlobalId);
            SphereUtils.getId(userGlobalId);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static SubsetKey getSubsetKey(String userGlobalId) throws ParseException {
        int idx = userGlobalId.indexOf(47);
        if (idx == -1) {
            throw new ParseException("Missing /", 0);
        }
        return SubsetKey.parse((short)3, userGlobalId.substring(0, idx));
    }

    public static int getId(String userGlobalId) throws ParseException {
        int idx = userGlobalId.indexOf(47);
        if (idx == -1) {
            throw new ParseException("Missing /", 0);
        }
        try {
            int id = Integer.parseInt(userGlobalId.substring(idx + 1));
            if (idx < 1) {
                throw new ParseException("Not positive integer", idx);
            }
            return id;
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Not integer", idx);
        }
    }

    public static List<Redacteur> wrap(Redacteur[] array) {
        return new RedacteurList(array);
    }

    private static class RedacteurList
    extends AbstractList<Redacteur>
    implements RandomAccess {
        private final Redacteur[] array;

        private RedacteurList(Redacteur[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Redacteur get(int index) {
            return this.array[index];
        }
    }
}

