/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.permission;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.permission.PermissionEntry;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.permission.ListFilterEngine;
import net.fichotheque.utils.EligibilityUtils;

public final class PermissionUtils {
    public static final PermissionSummary FICHOTHEQUEADMIN_PERMISSIONSUMMARY = new FichothequeAdminPermissionSummary();

    private PermissionUtils() {
    }

    public static Predicate<FicheMeta> getFichePredicate(PermissionSummary summary) {
        if (summary.isFichothequeAdmin()) {
            return EligibilityUtils.ALL_FICHE_PREDICATE;
        }
        return new RedacteurFichePredicate(summary);
    }

    public static boolean junctionTest(SubsetItem subsetItem, PermissionSummary permissionSummary, boolean read) {
        boolean notEmpty;
        List<PermissionEntry> permissionEntryList = ListFilterEngine.filter(subsetItem.getSubset(), Collections.singletonList(subsetItem), permissionSummary);
        boolean bl = notEmpty = !permissionEntryList.isEmpty();
        if (read) {
            return notEmpty;
        }
        return notEmpty && permissionEntryList.get(0).isEditable();
    }

    private static class RedacteurFichePredicate
    implements Predicate<FicheMeta> {
        private final PermissionSummary permissionSummary;

        private RedacteurFichePredicate(PermissionSummary permissionSummary) {
            this.permissionSummary = permissionSummary;
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            return this.permissionSummary.canRead(ficheMeta);
        }
    }

    private static class FichothequeAdminPermissionSummary
    implements PermissionSummary {
        private FichothequeAdminPermissionSummary() {
        }

        @Override
        public int getReadLevel(SubsetKey subsetKey) {
            return 5;
        }

        @Override
        public int getWriteLevel(SubsetKey subsetKey) {
            return 5;
        }

        @Override
        public boolean canCreate(SubsetKey subsetKey) {
            return true;
        }

        @Override
        public boolean isSubsetAdmin(SubsetKey subsetKey) {
            return true;
        }

        @Override
        public boolean isFichothequeAdmin() {
            return true;
        }

        @Override
        public boolean hasRole(String roleName) {
            return true;
        }

        @Override
        public boolean canDo(String actionName) {
            return true;
        }

        @Override
        public Predicate<Subset> getSubsetAccessPredicate() {
            return EligibilityUtils.ALL_SUBSET_PREDICATE;
        }

        @Override
        public boolean canRead(FicheMeta ficheMeta) {
            return true;
        }

        @Override
        public boolean canWrite(FicheMeta ficheMeta) {
            return true;
        }
    }
}

