/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.permission;

import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.permission.PermissionPredicate;

public class PermissionSubsetEligibility
implements SubsetEligibility {
    private final PermissionSummary permissionSummary;
    private final boolean read;
    private final Predicate<SubsetItem> permissionPredicate;

    private PermissionSubsetEligibility(PermissionSummary permissionSummary, boolean read) {
        this.permissionSummary = permissionSummary;
        this.read = read;
        this.permissionPredicate = read ? PermissionPredicate.read(permissionSummary) : PermissionPredicate.write(permissionSummary);
    }

    @Override
    public boolean accept(SubsetKey subsetKey) {
        int level = this.read ? this.permissionSummary.getReadLevel(subsetKey) : this.permissionSummary.getWriteLevel(subsetKey);
        return level != 0;
    }

    @Override
    public Predicate<SubsetItem> getPredicate(Subset subset) {
        return this.permissionPredicate;
    }

    public static PermissionSubsetEligibility read(PermissionSummary permissionSummary) {
        return new PermissionSubsetEligibility(permissionSummary, true);
    }

    public static PermissionSubsetEligibility write(PermissionSummary permissionSummary) {
        return new PermissionSubsetEligibility(permissionSummary, false);
    }
}

