/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.span;

import net.fichotheque.tools.parsers.span.BracketsParser;
import net.fichotheque.tools.parsers.span.EmphasisParser;
import net.fichotheque.tools.parsers.span.HttpParser;
import net.fichotheque.tools.parsers.span.SpanParseResult;
import net.fichotheque.tools.parsers.span.WwwParser;
import net.mapeadores.util.text.TypoOptions;

public abstract class SpanParser {
    SpanParser() {
    }

    public static SpanParser getEmphasisParser(TypoOptions typoOptions) {
        return new EmphasisParser(typoOptions);
    }

    public static SpanParser getBracketsParser(TypoOptions typoOptions) {
        return new BracketsParser(typoOptions);
    }

    public static SpanParser getHttpParser() {
        return new HttpParser();
    }

    public static SpanParser getWwwParser() {
        return new WwwParser();
    }

    public abstract SpanParseResult parse(String var1, int var2);

    public abstract char getStartChar();

    static boolean checkCharInUrl(char c) {
        if (c < '!' || c > '~') {
            return false;
        }
        switch (c) {
            case '\"': 
            case '<': 
            case '>': 
            case '\\': 
            case '^': 
            case '`': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    static int appendUrl(String source, StringBuilder buftexte, int beginIndex) {
        boolean valid;
        int length = source.length();
        int stopIndex = beginIndex - 1;
        UrlTester urlTester = new UrlTester(source);
        int i = beginIndex;
        while (i < length && (valid = urlTester.testChar(i))) {
            buftexte.append(source.charAt(i));
            stopIndex = i++;
        }
        return stopIndex;
    }

    static String getValue(String source, int beginIndex, int stopIndex, char stopChar) {
        StringBuilder buf = new StringBuilder();
        for (int i = beginIndex; i < stopIndex; ++i) {
            char next;
            char carac = source.charAt(i);
            if (i == beginIndex && carac == ' ') continue;
            if (carac == '\\' && i < stopIndex - 1 && ((next = source.charAt(i + 1)) == stopChar || next == '\\')) {
                buf.append(next);
                ++i;
                continue;
            }
            buf.append(carac);
        }
        return buf.toString();
    }

    static int getStopIndex(String source, int beginIndex, char stopChar) {
        int length = source.length();
        for (int i = beginIndex; i < length; ++i) {
            char carac = source.charAt(i);
            if (carac == stopChar) {
                return i;
            }
            if (carac != '\\') continue;
            ++i;
        }
        return -1;
    }

    private static class UrlTester {
        private final String source;
        private int parenthesisOpened;

        private UrlTester(String source) {
            this.source = source;
            this.parenthesisOpened = 0;
        }

        private boolean testChar(int index) {
            char c = this.source.charAt(index);
            if (!SpanParser.checkCharInUrl(c)) {
                return false;
            }
            boolean testNext = false;
            switch (c) {
                case ',': 
                case '.': 
                case ';': 
                case '?': {
                    testNext = true;
                    break;
                }
                case '(': {
                    ++this.parenthesisOpened;
                    break;
                }
                case ')': {
                    --this.parenthesisOpened;
                    if (this.parenthesisOpened >= 0) break;
                    return false;
                }
            }
            if (testNext) {
                if (index == this.source.length() - 1) {
                    return false;
                }
                char nextChar = this.source.charAt(index + 1);
                if (!SpanParser.checkCharInUrl(nextChar)) {
                    return false;
                }
            }
            return true;
        }
    }
}

