/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.ficheblock;

import java.util.List;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.utils.FicheUtils;

class ParagraphState {
    private boolean first = true;
    private boolean previousH = false;
    private int whiteLineCount = 0;
    private Atts previousAtts = null;

    ParagraphState() {
    }

    void reinit() {
        this.first = true;
        this.previousH = false;
        this.whiteLineCount = 0;
        this.previousAtts = null;
    }

    boolean isFirst() {
        return this.first;
    }

    void increaseWhiteLineCount() {
        if (!this.first) {
            ++this.whiteLineCount;
        }
    }

    void checkH() {
        this.previousH = true;
        this.whiteLineCount = 0;
        this.first = false;
    }

    void flushWhiteLines(List<FicheBlock> ficheBlockList) {
        if (this.previousH) {
            --this.whiteLineCount;
        }
        this.previousH = false;
        if (this.whiteLineCount > 1) {
            for (int i = 1; i < this.whiteLineCount; ++i) {
                ficheBlockList.add(new P());
            }
        }
        this.whiteLineCount = 0;
        this.first = false;
    }

    void flushPreviousAtts(List<FicheBlock> ficheBlockList) {
        if (this.previousAtts != null && !this.previousAtts.hasOnlyAutomaticAtts()) {
            this.flushWhiteLines(ficheBlockList);
            P p = new P();
            FicheUtils.populate(p, this.previousAtts);
            this.previousAtts = null;
        }
    }

    Atts getPreviousAtts() {
        return this.previousAtts;
    }

    void setPreviousAtts(Atts previousAtts) {
        this.previousAtts = previousAtts;
    }
}

