/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.ficheblock;

import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.ZoneBlock;
import net.fichotheque.tools.parsers.TextContentParser;
import net.mapeadores.util.text.StringUtils;

abstract class BlockParser {
    private int endIndex;
    private FicheBlock ficheBlock;

    BlockParser() {
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    protected void setParseResult(int endIndex, FicheBlock ficheBlock) {
        this.endIndex = endIndex;
        this.ficheBlock = ficheBlock;
    }

    public abstract void parse(String[] var1, int var2, Atts var3);

    public abstract boolean isStartLine(String var1);

    public FicheBlock getFicheBlock() {
        return this.ficheBlock;
    }

    public static int parseZoneBlockElements(ZoneBlock zoneBlock, int beginIndex, String[] lineArray, TextContentParser textContentParser) {
        int length = lineArray.length;
        int blankLineCount = 0;
        while (beginIndex < length) {
            String line = StringUtils.cleanString(lineArray[beginIndex]);
            if (line.length() > 0) {
                if (line.startsWith("n=")) {
                    blankLineCount = 0;
                    textContentParser.parse(zoneBlock.getNumeroBuilder(), line.substring(2).trim());
                    ++beginIndex;
                    continue;
                }
                if (!line.startsWith("l=")) break;
                blankLineCount = 0;
                textContentParser.parse(zoneBlock.getLegendeBuilder(), line.substring(2).trim());
                ++beginIndex;
                continue;
            }
            ++blankLineCount;
            ++beginIndex;
        }
        return beginIndex - blankLineCount;
    }
}

