/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.junction;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.junction.JunctionChanges;
import net.fichotheque.tools.junction.JunctionChangeBuilder;
import net.fichotheque.tools.junction.JunctionChangesBuilder;

public final class JunctionRemoveParser {
    private JunctionRemoveParser() {
    }

    public static JunctionChanges parseRemove(String[] values, Fichotheque fichotheque, Predicate<SubsetItem> predicate) {
        LinkedHashMap<SubsetItem, JunctionChangeBuilder> map = new LinkedHashMap<SubsetItem, JunctionChangeBuilder>();
        for (String value : values) {
            int idx = value.indexOf(47);
            if (idx <= 0) continue;
            try {
                SubsetItem subsetItem;
                IncludeKey includeKey = IncludeKey.parse(value.substring(0, idx));
                int id = Integer.parseInt(value.substring(idx + 1));
                Subset subset = fichotheque.getSubset(includeKey.getSubsetKey());
                if (subset == null || (subsetItem = subset.getSubsetItemById(id)) == null || predicate != null && !predicate.test(subsetItem)) continue;
                JunctionChangeBuilder builder = (JunctionChangeBuilder)map.get(subsetItem);
                if (builder == null) {
                    builder = new JunctionChangeBuilder();
                    map.put(subsetItem, builder);
                }
                builder.addRemovedMode(includeKey.getMode());
            }
            catch (NumberFormatException | ParseException exception) {
                // empty catch block
            }
        }
        JunctionChangesBuilder junctionChangesBuilder = new JunctionChangesBuilder();
        for (Map.Entry entry : map.entrySet()) {
            junctionChangesBuilder.addEntry((SubsetItem)entry.getKey(), ((JunctionChangeBuilder)entry.getValue()).toJunctionChange());
        }
        return junctionChangesBuilder.toJunctionChanges();
    }
}

