/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.handlers;

import net.fichotheque.Subset;
import net.fichotheque.tools.corpus.FicheChangeBuilder;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.TiesImportBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.TiesParser;
import net.fichotheque.tools.importation.parsers.handlers.AttributeHandler;
import net.fichotheque.tools.importation.parsers.handlers.FicheHandler;
import net.fichotheque.tools.importation.parsers.handlers.JunctionHandlers;
import net.fichotheque.tools.importation.parsers.handlers.LabelHandler;
import net.fichotheque.tools.parsers.FicheParser;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.text.LabelChangeBuilder;

public final class HandlerUtils {
    private HandlerUtils() {
    }

    public static void populate(LabelChangeBuilder labelChangeBuilder, LabelHandler[] labelHandlerArray, Row row, ParseResultBuilder parseResultBuilder, int rowNumber) {
        for (LabelHandler labelHandler : labelHandlerArray) {
            try {
                labelHandler.handle(row, labelChangeBuilder);
            }
            catch (ErrorMessageException eme) {
                parseResultBuilder.addParseErrorMessage(rowNumber, eme.getErrorMessage());
            }
        }
    }

    public static void populate(AttributeChangeBuilder attributeChangeBuilder, AttributeHandler[] attributeHandlerArray, Row row) {
        for (AttributeHandler attributeHandler : attributeHandlerArray) {
            attributeHandler.handle(row, attributeChangeBuilder);
        }
    }

    public static void populate(TiesImportBuilder tiesImportBuilder, JunctionHandlers junctionHandlers, Row row, Subset subset, ImportationParseContext parseContext) {
        TiesParser tiesParser = new TiesParser(subset, tiesImportBuilder, parseContext);
        junctionHandlers.handle(row, tiesParser);
    }

    public static void populate(FicheChangeBuilder ficheChangeBuilder, FicheHandler[] ficheHandlerArray, Row row, FicheParser ficheParser) {
        FicheParser.Buffer buffer = ficheParser.getBuffer(ficheChangeBuilder);
        if (ficheHandlerArray != null) {
            for (FicheHandler ficheHandler : ficheHandlerArray) {
                ficheHandler.handle(row, buffer);
            }
        }
        buffer.flushParsedSubfields();
    }
}

