/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.from.html.handlers;

import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.tools.from.html.BlockConversion;
import net.fichotheque.tools.from.html.ElementHandler;
import net.fichotheque.tools.from.html.FlowBuffer;
import net.fichotheque.tools.from.html.TagUtils;
import net.mapeadores.util.text.StringUtils;
import org.jsoup.nodes.Element;

public class BlockquoteHandler
extends ElementHandler {
    public static final BlockquoteHandler INSTANCE = new BlockquoteHandler();

    private BlockquoteHandler() {
    }

    @Override
    public int handle(Element element, FlowBuffer flowBuffer) {
        String tagName;
        switch (TagUtils.getTagType(element)) {
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        flowBuffer.flushInline();
        switch (tagName = element.tagName()) {
            case "p": 
            case "h1": 
            case "h2": 
            case "h3": 
            case "h4": 
            case "h5": 
            case "h6": {
                this.addP(element, flowBuffer);
                break;
            }
            case "pre": {
                this.addPre(element, flowBuffer);
                break;
            }
            default: {
                flowBuffer.addFicheBlocks(INSTANCE.convertChildNodes(element));
            }
        }
        return 1;
    }

    private void addP(Element element, FlowBuffer flowBuffer) {
        flowBuffer.flushInline();
        P p = new P(1);
        BlockConversion.populate(element, p);
        flowBuffer.addFicheBlock(p);
    }

    private void addPre(Element element, FlowBuffer flowBuffer) {
        flowBuffer.flushInline();
        String[] lines = StringUtils.getLineTokens(element.wholeText(), (short)0);
        P p = new P(1);
        boolean next = false;
        for (String line : lines) {
            if (next) {
                p.addS(new S(20));
            } else {
                next = true;
            }
            line = line.trim();
            if (line.length() <= 0) continue;
            S s = new S(18);
            s.setValue(line);
            p.addS(s);
        }
        flowBuffer.addFicheBlock(p);
    }
}

