/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.from.html;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.tools.from.html.ContentBuffer;
import net.fichotheque.tools.from.html.FlowBuffer;
import net.fichotheque.tools.from.html.InlineConversion;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public abstract class ElementHandler {
    public abstract int handle(Element var1, FlowBuffer var2);

    public List<FicheBlock> convertChildNodes(Element parent) {
        return this.convertChildNodes(parent.childNodes());
    }

    public List<FicheBlock> convertChildNodes(List<Node> nodeList) {
        InternalFlowBuffer flowBuffer = new InternalFlowBuffer();
        int skip = 0;
        for (Node node : nodeList) {
            if (skip > 0) {
                --skip;
                continue;
            }
            if (node instanceof TextNode) {
                flowBuffer.addInlindeNode(node);
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            skip = this.handle(child, flowBuffer);
            if (skip == 0) {
                if (InlineConversion.canConvert(child)) {
                    flowBuffer.addInlindeNode((Node)child);
                    continue;
                }
                String text = child.text();
                if (text.length() <= 0) continue;
                flowBuffer.addInlindeNode((Node)new TextNode(text));
                continue;
            }
            --skip;
        }
        flowBuffer.flushInline();
        return flowBuffer.result;
    }

    private static boolean isWhiteLine(FicheBlock ficheBlock) {
        Object first;
        if (!(ficheBlock instanceof P)) {
            return false;
        }
        P p = (P)ficheBlock;
        int size = p.size();
        if (size == 0) {
            return true;
        }
        return size == 1 && (first = p.get(0)) instanceof S && ((S)first).getType() == 20;
    }

    private static class InternalFlowBuffer
    implements FlowBuffer {
        private final List<FicheBlock> result = new ArrayList<FicheBlock>();
        private final List<Node> inlineNodeList = new ArrayList<Node>();
        private int emptyLines = 0;

        private InternalFlowBuffer() {
        }

        private void addInlindeNode(Node node) {
            this.inlineNodeList.add(node);
        }

        @Override
        public void flushInline() {
            if (this.inlineNodeList.isEmpty()) {
                return;
            }
            ContentBuffer buf = ContentBuffer.init().add(this.inlineNodeList);
            if (!buf.isEmpty()) {
                P p = new P();
                buf.flush(p);
                this.result.add(p);
                this.emptyLines = 0;
            }
            this.inlineNodeList.clear();
        }

        @Override
        public void addFicheBlock(FicheBlock ficheBlock) {
            this.flushInline();
            if (ficheBlock != null) {
                if (ElementHandler.isWhiteLine(ficheBlock)) {
                    ++this.emptyLines;
                } else {
                    if (this.emptyLines > 1 && ficheBlock instanceof P) {
                        for (int i = 1; i < this.emptyLines; ++i) {
                            this.result.add(new P());
                        }
                    }
                    this.emptyLines = 0;
                    this.result.add(ficheBlock);
                }
            }
        }
    }
}

