/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.format.SubsetPathKey;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.tools.format.tokenizers.SubsetPathSourceTokenizer;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.localisation.Lang;

public abstract class TokenizerProvider {
    public static final TokenizerProvider NULL = new SimpleTokenizerProvider(FormatterUtils.EMPTY_TOKENIZER);

    public abstract Tokenizer getTokenizer(String var1);

    public static TokenizerProvider simple(Tokenizer sourceTokenizer) {
        return new SimpleTokenizerProvider(sourceTokenizer);
    }

    public static TokenizerProvider prefix(String prefix, Map<String, Tokenizer> sourceTokenizerMap) {
        return new MapTokenizerProvider(prefix, sourceTokenizerMap);
    }

    public static TokenizerProvider subsetPath(Fichotheque fichotheque, SubsetPathKey subsetPathKey, TokenizerProvider sourceTokenizerProvider, boolean globalSelect) {
        return new SubsetPathTokenizerProvider(fichotheque, subsetPathKey, sourceTokenizerProvider, globalSelect);
    }

    public static ByLang toByLangProvider(List<TokenizerProvider> tokenizerProviderList) {
        int size = tokenizerProviderList.size();
        Tokenizer[] array = new Tokenizer[size];
        boolean done = true;
        for (int i = 0; i < size; ++i) {
            TokenizerProvider tokenizerProvider = tokenizerProviderList.get(i);
            if (tokenizerProvider instanceof SimpleTokenizerProvider) {
                array[i] = ((SimpleTokenizerProvider)tokenizerProvider).getTokenizer();
                continue;
            }
            if (tokenizerProvider instanceof SubsetPathTokenizerProvider && ((SubsetPathTokenizerProvider)tokenizerProvider).isSimple()) {
                array[i] = tokenizerProvider.getTokenizer(null);
                continue;
            }
            done = false;
            break;
        }
        if (done) {
            List<Tokenizer> tokenizerList = FormatterUtils.wrap(array);
            return new SimpleByLang(tokenizerList);
        }
        return new MapByLang(tokenizerProviderList);
    }

    private static class SimpleTokenizerProvider
    extends TokenizerProvider {
        private final Tokenizer tokenizer;

        private SimpleTokenizerProvider(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        @Override
        public Tokenizer getTokenizer(String name) {
            return this.tokenizer;
        }

        private Tokenizer getTokenizer() {
            return this.tokenizer;
        }
    }

    private static class MapTokenizerProvider
    extends TokenizerProvider {
        private final String prefix;
        private final Map<String, Tokenizer> map;

        MapTokenizerProvider(String prefix, Map<String, Tokenizer> sourceTokenizerMap) {
            this.prefix = prefix;
            this.map = sourceTokenizerMap;
        }

        @Override
        public Tokenizer getTokenizer(String name) {
            Tokenizer tokenizer = this.map.get(name);
            if (tokenizer == null) {
                tokenizer = this.map.get("");
            }
            if (tokenizer == null) {
                tokenizer = this.map.values().iterator().next();
            }
            return tokenizer;
        }
    }

    private static class SubsetPathTokenizerProvider
    extends TokenizerProvider {
        private final Fichotheque fichotheque;
        private final SubsetPathKey subsetPathKey;
        private final TokenizerProvider finalTokenizerProvider;
        private final boolean globalSelect;

        SubsetPathTokenizerProvider(Fichotheque fichotheque, SubsetPathKey subsetPathKey, TokenizerProvider sourceTokenizerProvider, boolean globalSelect) {
            this.fichotheque = fichotheque;
            this.subsetPathKey = subsetPathKey;
            this.finalTokenizerProvider = sourceTokenizerProvider;
            this.globalSelect = globalSelect;
        }

        @Override
        public Tokenizer getTokenizer(String name) {
            Tokenizer finalTokenizer = this.finalTokenizerProvider.getTokenizer(name);
            return new SubsetPathSourceTokenizer(this.fichotheque, this.subsetPathKey, finalTokenizer, this.globalSelect);
        }

        boolean isSimple() {
            return this.finalTokenizerProvider instanceof SimpleTokenizerProvider;
        }

        TokenizerProvider getFinalTokenizerProvider() {
            return this.finalTokenizerProvider;
        }
    }

    private static class SimpleByLang
    extends ByLang {
        private final List<Tokenizer> tokenizerList;

        private SimpleByLang(List<Tokenizer> tokenizerList) {
            this.tokenizerList = tokenizerList;
        }

        @Override
        public List<Tokenizer> getTokenizerList(Lang lang) {
            return this.tokenizerList;
        }
    }

    private static class MapByLang
    extends ByLang {
        private final Map<Lang, List<Tokenizer>> tokenizerListMap = new HashMap<Lang, List<Tokenizer>>();
        private final List<TokenizerProvider> tokenizerProviderList;

        private MapByLang(List<TokenizerProvider> tokenizerProviderList) {
            this.tokenizerProviderList = tokenizerProviderList;
        }

        @Override
        public List<Tokenizer> getTokenizerList(Lang lang) {
            List<Tokenizer> tokenizerList = this.tokenizerListMap.get(lang);
            if (tokenizerList == null) {
                int size = this.tokenizerProviderList.size();
                String name = lang == null ? "" : lang.toString();
                Tokenizer[] array = new Tokenizer[size];
                for (int i = 0; i < size; ++i) {
                    TokenizerProvider provider = this.tokenizerProviderList.get(i);
                    array[i] = provider.getTokenizer(name);
                }
                tokenizerList = FormatterUtils.wrap(array);
                this.tokenizerListMap.put(lang, tokenizerList);
            }
            return tokenizerList;
        }
    }

    public static abstract class ByLang {
        public abstract List<Tokenizer> getTokenizerList(Lang var1);
    }
}

