/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.parsers;

import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheItemFormatter;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.tools.format.DefaultPatternCatalog;
import net.fichotheque.tools.format.FormatterEngineUtils;
import net.fichotheque.tools.format.catalogs.SubfieldFormatterCatalog;
import net.fichotheque.tools.format.parsers.FicheItemFormatterParser;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class SubfieldFormatterParser {
    private SubfieldFormatterParser() {
    }

    public static SubfieldFormatter parse(String subfieldType, String pattern, FormatContext formatContext, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPatternCatalog.subfield(subfieldType);
        }
        try {
            return SubfieldFormatterParser.parse(subfieldType, pattern, formatContext);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static SubfieldFormatter parse(String subfieldType, String pattern, FormatContext formatContext) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext, subfieldType), pattern);
        return new InternalSubfieldFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final FormatContext formatContext;
        private final String subfieldType;

        private InternalInstructionResolver(FormatContext formatContext, String subfieldType) {
            this.formatContext = formatContext;
            this.subfieldType = subfieldType;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            Object formatter;
            InstructionResolver resolver = this.formatContext.getInstructionResolverProvider().getInstructionResolver(SubfieldFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            switch (this.subfieldType) {
                case "surname": 
                case "forename": 
                case "nonlatin": 
                case "surnamefirst": 
                case "src": 
                case "alt": 
                case "title": 
                case "lat": 
                case "lon": 
                case "currency": 
                case "value": {
                    return this.resolveStringValue(instruction);
                }
                case "others": 
                case "amount": {
                    return this.resolveAmount(instruction, this.formatContext);
                }
            }
            throw new SwitchException("subfieldType = " + this.subfieldType);
        }

        private SubfieldFormatter resolveStringValue(Instruction instruction) {
            String key;
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "formsyntax": {
                    return SubfieldFormatterCatalog.STRING_VALUE;
                }
                case "value": {
                    boolean up = FormatterEngineUtils.isUppercase(instruction);
                    if (up) {
                        return SubfieldFormatterCatalog.STRING_VALUE_UP;
                    }
                    return SubfieldFormatterCatalog.STRING_VALUE;
                }
            }
            return null;
        }

        private SubfieldFormatter resolveAmount(Instruction instruction, FormatContext formatContext) throws ErrorMessageException {
            FicheItemFormatter ficheItemFormatter = FicheItemFormatterParser.resolveFicheItem(instruction, "amount", formatContext, null);
            if (ficheItemFormatter == null) {
                return null;
            }
            return new SubfieldFormatterCatalog.FicheItemSubfield(ficheItemFormatter);
        }
    }

    private static class InternalSubfieldFormatter
    implements SubfieldFormatter {
        private final Object[] partArray;

        private InternalSubfieldFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatSubfield(SubfieldValue subfieldValue, FormatSource formatSource) {
            if (subfieldValue == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                SubfieldFormatter formatter = (SubfieldFormatter)obj;
                buf.append(formatter.formatSubfield(subfieldValue, formatSource));
            }
            return buf.toString();
        }
    }
}

