/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.catalogs;

import java.io.IOException;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.MotcleFormatter;
import net.fichotheque.json.MotcleJson;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.format.FormatterEngineUtils;
import net.fichotheque.tools.format.JsonParameters;
import net.fichotheque.tools.format.LangParameters;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;

public final class MotcleFormatterCatalog {
    public static final MotcleFormatter ID = (motcle, weight, formatSource) -> String.valueOf(motcle.getId());
    public static final MotcleFormatter IDALPHA = (motcle, weight, formatSource) -> {
        String idalpha = motcle.getIdalpha();
        if (idalpha == null) {
            idalpha = "";
        }
        return idalpha;
    };
    public static final MotcleFormatter IDALPHA_SIGNIFICANT = (motcle, weight, formatSource) -> {
        String idalpha = motcle.getSignificantIdalpha();
        if (idalpha == null) {
            idalpha = "";
        }
        return idalpha;
    };
    public static final MotcleFormatter LANG = (motcle, weight, formatSource) -> {
        if (!motcle.isBabelienType()) {
            return "";
        }
        net.mapeadores.util.text.Label label = motcle.getBabelienLabel();
        return label.getLang().toString();
    };
    public static final MotcleFormatter WEIGHT = (motcle, weight, formatSource) -> String.valueOf(weight);
    public static final MotcleFormatter PARENT_ID = (motcle, weight, formatSource) -> {
        Motcle parent = motcle.getParent();
        if (parent != null) {
            return String.valueOf(parent.getId());
        }
        return "";
    };
    public static final MotcleFormatter PARENT_IDALPHA = (motcle, weight, formatSource) -> {
        String idalpha = null;
        Motcle parentMotcle = motcle.getParent();
        if (parentMotcle != null) {
            idalpha = parentMotcle.getIdalpha();
        }
        if (idalpha == null) {
            idalpha = "";
        }
        return idalpha;
    };
    public static final MotcleFormatter PARENT_IDALPHA_SIGNIFICANT = (motcle, weight, formatSource) -> {
        String idalpha = null;
        Motcle parentMotcle = motcle.getParent();
        if (parentMotcle != null) {
            idalpha = parentMotcle.getSignificantIdalpha();
        }
        if (idalpha == null) {
            idalpha = "";
        }
        return idalpha;
    };
    public static final MotcleFormatter POSITION = (motcle, weight, formatSource) -> String.valueOf(motcle.getChildIndex() + 1);
    public static final MotcleFormatter POSITION_GLOBAL = (motcle, weight, formatSource) -> ThesaurusUtils.getGlobalPosition(motcle);
    public static final MotcleFormatter THESAURUS = (motcle, weight, formatSource) -> motcle.getSubsetName();
    public static final MotcleFormatter WITHWEIGHTFILTER_FORMSYNTAX_FORMATTER = new InternalFormSyntax(true);
    public static final MotcleFormatter WITHOUTWEIGHTFILTER_FORMSYNTAX_FORMATTER = new InternalFormSyntax(false);

    private MotcleFormatterCatalog() {
    }

    private static class InternalFormSyntax
    implements MotcleFormatter {
        private final boolean withWeightFilter;

        private InternalFormSyntax(boolean withWeightFilter) {
            this.withWeightFilter = withWeightFilter;
        }

        @Override
        public String formatMotcle(Motcle motcle, int weight, FormatSource formatSource) {
            if (this.withWeightFilter || weight == 1) {
                String idalpha = motcle.getIdalpha();
                if (idalpha != null) {
                    return idalpha;
                }
                return String.valueOf(motcle.getId());
            }
            StringBuilder buf = new StringBuilder();
            String idalpha = motcle.getIdalpha();
            if (idalpha != null) {
                buf.append(idalpha);
            } else {
                buf.append(String.valueOf(motcle.getId()));
            }
            buf.append(" <");
            buf.append(weight);
            buf.append(">");
            return buf.toString();
        }
    }

    public static class Label
    implements MotcleFormatter {
        private final LangParameters langParameters;

        public Label(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatMotcle(Motcle motcle, int weight, FormatSource formatSource) {
            Lang[] array;
            StringBuilder buf = new StringBuilder();
            for (Lang lang : array = LangParameters.checkLangArray(this.langParameters, formatSource)) {
                net.mapeadores.util.text.Label label = motcle.getLabels().getLangPartCheckedLabel(lang);
                if (label == null) continue;
                if (buf.length() > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                buf.append(label.getLabelString());
            }
            return buf.toString();
        }
    }

    public static class Json
    implements MotcleFormatter {
        private final JsonParameters jsonParameters;
        private final LangContext customLangContext;

        public Json(JsonParameters jsonParameters, LangContext customLangContext) {
            this.jsonParameters = jsonParameters;
            this.customLangContext = customLangContext;
        }

        @Override
        public String formatMotcle(Motcle motcle, int weight, FormatSource formatSource) {
            Cell[] cellArray = FormatterEngineUtils.resolve(motcle, this.jsonParameters, formatSource);
            LangContext langContext = this.customLangContext != null ? this.customLangContext : formatSource.getLangContext();
            StringBuilder buf = new StringBuilder();
            JSONWriter jsonWriter = new JSONWriter(buf);
            try {
                jsonWriter.object();
                MotcleJson.properties(jsonWriter, motcle, langContext, this.jsonParameters.getPropertyEligibility(), cellArray);
                jsonWriter.endObject();
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            return buf.toString();
        }
    }
}

