/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.catalogs;

import java.io.IOException;
import net.fichotheque.album.Illustration;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.IllustrationFormatter;
import net.fichotheque.json.IllustrationJson;
import net.fichotheque.tools.format.JsonParameters;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.json.JSONWriter;

public final class IllustrationFormatterCatalog {
    public static final IllustrationFormatter ALBUM = (illustration, weight, formatSource) -> illustration.getSubsetName();
    public static final IllustrationFormatter FORMAT = (illustration, weight, formatSource) -> illustration.getFormatType();
    public static final IllustrationFormatter ID = (illustration, weight, formatSource) -> String.valueOf(illustration.getId());
    public static final IllustrationFormatter WEIGHT = (illustration, weight, formatSource) -> String.valueOf(weight);
    public static final IllustrationFormatter WITHWEIGHTFILTER_FORMSYNTAX = new InternalFormSyntax(true);
    public static final IllustrationFormatter WITHOUTWEIGHTFILTER_FORMSYNTAX = new InternalFormSyntax(false);

    private IllustrationFormatterCatalog() {
    }

    private static class InternalFormSyntax
    implements IllustrationFormatter {
        private final boolean withWeightFilter;

        private InternalFormSyntax(boolean withWeightFilter) {
            this.withWeightFilter = withWeightFilter;
        }

        @Override
        public String formatIllustration(Illustration illustration, int weight, FormatSource formatSource) {
            if (this.withWeightFilter || weight == 1) {
                return String.valueOf(illustration.getId());
            }
            StringBuilder buf = new StringBuilder();
            buf.append(String.valueOf(illustration.getId()));
            buf.append(" <");
            buf.append(weight);
            buf.append(">");
            return buf.toString();
        }
    }

    public static class Json
    implements IllustrationFormatter {
        private final JsonParameters jsonParameters;

        public Json(JsonParameters jsonParameters) {
            this.jsonParameters = jsonParameters;
        }

        @Override
        public String formatIllustration(Illustration illustration, int weight, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            JSONWriter jsonWriter = new JSONWriter(buf);
            try {
                jsonWriter.object();
                IllustrationJson.properties(jsonWriter, illustration, this.jsonParameters.getPropertyEligibility());
                jsonWriter.endObject();
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            return buf.toString();
        }
    }
}

