/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.catalogs;

import java.io.IOException;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheMetaFormatter;
import net.fichotheque.json.FicheMetaJson;
import net.fichotheque.tools.format.FormatterEngineUtils;
import net.fichotheque.tools.format.JsonParameters;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;

public final class FicheMetaFormatterCatalog {
    public static final FicheMetaFormatter CORPUS = (ficheMeta, weight, formatSource) -> ficheMeta.getSubsetName();
    public static final FicheMetaFormatter ID = (ficheMeta, weight, formatSource) -> String.valueOf(ficheMeta.getId());
    public static final FicheMetaFormatter LANG = (ficheMeta, weight, formatSource) -> {
        Lang lang = ficheMeta.getLang();
        if (lang != null) {
            return lang.toString();
        }
        return "";
    };
    public static final FicheMetaFormatter WEIGHT = (ficheMeta, weight, formatSource) -> String.valueOf(weight);
    public static final FicheMetaFormatter TITLE = (ficheMeta, weight, formatSource) -> ficheMeta.getTitle();

    private FicheMetaFormatterCatalog() {
    }

    public static class FormSyntax
    implements FicheMetaFormatter {
        private final boolean withWeightFilter;
        private final boolean withCorpusName;

        public FormSyntax(boolean withWeightFilter, boolean withCorpusName) {
            this.withWeightFilter = withWeightFilter;
            this.withCorpusName = withCorpusName;
        }

        @Override
        public String formatFicheMeta(FicheMeta ficheMeta, int weight, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            if (this.withCorpusName) {
                buf.append(ficheMeta.getSubsetName());
                buf.append('/');
            }
            buf.append(String.valueOf(ficheMeta.getId()));
            if (!this.withWeightFilter && weight > 1) {
                buf.append(" <");
                buf.append(weight);
                buf.append(">");
            }
            return buf.toString();
        }
    }

    public static class Json
    implements FicheMetaFormatter {
        private final JsonParameters jsonParameters;

        public Json(JsonParameters jsonParameters) {
            this.jsonParameters = jsonParameters;
        }

        @Override
        public String formatFicheMeta(FicheMeta ficheMeta, int weight, FormatSource formatSource) {
            Cell[] cellArray = FormatterEngineUtils.resolve(ficheMeta, this.jsonParameters, formatSource);
            StringBuilder buf = new StringBuilder();
            JSONWriter jw = new JSONWriter(buf);
            try {
                jw.object();
                FicheMetaJson.properties(jw, ficheMeta, this.jsonParameters.getPropertyEligibility(), cellArray);
                jw.endObject();
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            return buf.toString();
        }
    }
}

