/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.catalogs;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.CountryItem;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.EmailItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.fiche.ImageItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.LinkItem;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.format.formatters.FicheItemFormatter;
import net.fichotheque.json.FicheItemJson;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.syntax.FormSyntax;
import net.fichotheque.tools.format.FormatterEngineUtils;
import net.fichotheque.tools.format.JsonParameters;
import net.fichotheque.tools.format.LangParameters;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.date.FuzzyDateFormatter;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.PropertyEligibility;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.MessageLocalisationProvider;
import net.mapeadores.util.localisation.SpecialCodes;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreSexagesimal;
import net.mapeadores.util.text.StringUtils;

public final class FicheItemFormatterCatalog {
    public static final FicheItemFormatter COUNTRY_CODE = (ficheItem, formatSource) -> {
        if (ficheItem instanceof CountryItem) {
            return ((CountryItem)ficheItem).getCountry().toString();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter LANGUAGE_CODE = (ficheItem, formatSource) -> {
        if (ficheItem instanceof LanguageItem) {
            return ((LanguageItem)ficheItem).getLang().toString();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter ITEM = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Item) {
            return ((Item)ficheItem).getValue();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PARA_RAW = (ficheItem, formatSource) -> {
        if (ficheItem instanceof ParaItem) {
            return ((ParaItem)ficheItem).contentToString();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter GEO_LAT = (ficheItem, formatSource) -> {
        if (ficheItem instanceof GeopointItem) {
            return ((GeopointItem)ficheItem).getLatitude().toString();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter GEO_LON = (ficheItem, formatSource) -> {
        if (ficheItem instanceof GeopointItem) {
            return ((GeopointItem)ficheItem).getLongitude().toString();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter LINK_HREF = (ficheItem, formatSource) -> {
        if (ficheItem instanceof LinkItem) {
            return ((LinkItem)ficheItem).getHref();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter LINK_TITLE = (ficheItem, formatSource) -> {
        if (ficheItem instanceof LinkItem) {
            return ((LinkItem)ficheItem).getTitle();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter LINK_COMMENT = (ficheItem, formatSource) -> {
        if (ficheItem instanceof LinkItem) {
            return ((LinkItem)ficheItem).getComment();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter IMAGE_SRC = (ficheItem, formatSource) -> {
        if (ficheItem instanceof ImageItem) {
            return ((ImageItem)ficheItem).getSrc();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter IMAGE_ALT = (ficheItem, formatSource) -> {
        if (ficheItem instanceof ImageItem) {
            return ((ImageItem)ficheItem).getAlt();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter IMAGE_TITLE = (ficheItem, formatSource) -> {
        if (ficheItem instanceof ImageItem) {
            return ((ImageItem)ficheItem).getTitle();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter EMAIL_COMPLETE = (ficheItem, formatSource) -> {
        if (ficheItem instanceof EmailItem) {
            return ((EmailItem)ficheItem).getEmailCore().toCompleteString();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter EMAIL_ADDRESS = (ficheItem, formatSource) -> {
        if (ficheItem instanceof EmailItem) {
            return ((EmailItem)ficheItem).getEmailCore().getAddrSpec();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter EMAIL_NAME = (ficheItem, formatSource) -> {
        if (ficheItem instanceof EmailItem) {
            return ((EmailItem)ficheItem).getEmailCore().getRealName();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter NUMBER_CODE = (ficheItem, formatSource) -> {
        if (ficheItem instanceof NumberItem) {
            return ((NumberItem)ficheItem).getDecimal().toString();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter AMOUNT_CODE = (ficheItem, formatSource) -> {
        if (ficheItem instanceof AmountItem) {
            return ((AmountItem)ficheItem).toString();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter AMOUNT_CURRENCY = (ficheItem, formatSource) -> {
        if (ficheItem instanceof AmountItem) {
            return ((AmountItem)ficheItem).getCurrency().getCurrencyCode();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter AMOUNT_DECIMAL = (ficheItem, formatSource) -> {
        if (ficheItem instanceof AmountItem) {
            return ((AmountItem)ficheItem).getDecimal().toString();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter AMOUNT_MONEYLONG = (ficheItem, formatSource) -> {
        if (ficheItem instanceof AmountItem) {
            return String.valueOf(((AmountItem)ficheItem).toMoneyLong());
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATE_CODE = (ficheItem, formatSource) -> {
        if (ficheItem instanceof DateItem) {
            return ((DateItem)ficheItem).getDate().toString();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATE_ISO = (ficheItem, formatSource) -> {
        if (ficheItem instanceof DateItem) {
            return ((DateItem)ficheItem).getDate().toISOString(false);
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATE_ISO_LAST = (ficheItem, formatSource) -> {
        if (ficheItem instanceof DateItem) {
            return ((DateItem)ficheItem).getDate().toISOString(true);
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATE_YEAR = (ficheItem, formatSource) -> {
        if (ficheItem instanceof DateItem) {
            return String.valueOf(((DateItem)ficheItem).getDate().getYear());
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATE_ISOMONTH = (ficheItem, formatSource) -> {
        if (ficheItem instanceof DateItem) {
            return ((DateItem)ficheItem).getDate().toMonthString(false);
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATE_ISOMONTH_LAST = (ficheItem, formatSource) -> {
        if (ficheItem instanceof DateItem) {
            return ((DateItem)ficheItem).getDate().toMonthString(true);
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_LOGIN = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            String userGlobalId = ((PersonItem)ficheItem).getRedacteurGlobalId();
            if (userGlobalId != null) {
                Redacteur redacteur = formatSource.getFichothequeQuestioner().getRedacteurByGlobalId(userGlobalId);
                if (redacteur != null) {
                    return redacteur.getLogin();
                }
                return "";
            }
            return "";
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_SPHERE = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            String redacteurGlobalId = ((PersonItem)ficheItem).getRedacteurGlobalId();
            if (redacteurGlobalId != null) {
                try {
                    SubsetKey sphereKey = SphereUtils.getSubsetKey(redacteurGlobalId);
                    return sphereKey.getSubsetName();
                }
                catch (ParseException pe) {
                    return "#ERR: wrong redacteurGlobaleId = " + redacteurGlobalId;
                }
            }
            return "";
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_CODE = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            String userGlobalId = ((PersonItem)ficheItem).getRedacteurGlobalId();
            if (userGlobalId != null) {
                Redacteur redacteur = formatSource.getFichothequeQuestioner().getRedacteurByGlobalId(userGlobalId);
                if (redacteur != null) {
                    return redacteur.getBracketStyle();
                }
                return userGlobalId;
            }
            return ((PersonItem)ficheItem).getPersonCore().toStandardStyle();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_STANDARD = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            PersonCore personCore = FormatterEngineUtils.toPersonCore(ficheItem, formatSource);
            return personCore.toStandardStyle();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_DIRECTORY = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            PersonCore personCore = FormatterEngineUtils.toPersonCore(ficheItem, formatSource);
            return personCore.toDirectoryStyle(false);
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_UPDIRECTORY = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            PersonCore personCore = FormatterEngineUtils.toPersonCore(ficheItem, formatSource);
            return personCore.toDirectoryStyle(true);
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_BIBLIO = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            PersonCore personCore = FormatterEngineUtils.toPersonCore(ficheItem, formatSource);
            return personCore.toBiblioStyle(false);
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_UPBIBLIO = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            PersonCore personCore = FormatterEngineUtils.toPersonCore(ficheItem, formatSource);
            return personCore.toBiblioStyle(true);
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_SURNAME = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            return FormatterEngineUtils.toPersonCore(ficheItem, formatSource).getSurname();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_UPSURNAME = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            return FormatterEngineUtils.toPersonCore(ficheItem, formatSource).getSurname().toUpperCase();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_FORENAME = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            return FormatterEngineUtils.toPersonCore(ficheItem, formatSource).getForename();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_NONLATIN = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            return FormatterEngineUtils.toPersonCore(ficheItem, formatSource).getNonlatin();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_SURNAMEFIRST = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            PersonCore personCore = FormatterEngineUtils.toPersonCore(ficheItem, formatSource);
            return personCore.isSurnameFirst() ? "1" : "0";
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSON_ORGANISM = (ficheItem, formatSource) -> {
        if (ficheItem instanceof PersonItem) {
            return ((PersonItem)ficheItem).getOrganism();
        }
        return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter FORMSYNTAX = (ficheItem, formatSource) -> FormSyntax.toString(ficheItem, formatSource.getFichothequeQuestioner(), null);

    private FicheItemFormatterCatalog() {
    }

    public static FicheItemFormatter newLinkHrefPart(String base) {
        if (base == null) {
            return LINK_HREF;
        }
        return new LinkHref(base);
    }

    public static FicheItemFormatter newImageSrcPart(String base) {
        if (base == null) {
            return IMAGE_SRC;
        }
        return new ImageSrc(base);
    }

    private static String getDefaultFormat(FicheItem ficheItem) {
        if (ficheItem instanceof Item) {
            return ((Item)ficheItem).getValue();
        }
        return "#ERROR: wrong ficheItem = " + ficheItem.getClass().getName();
    }

    public static class LinkHref
    implements FicheItemFormatter {
        private final String base;

        public LinkHref(String base) {
            this.base = base;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (ficheItem instanceof LinkItem) {
                String href = ((LinkItem)ficheItem).getHref();
                if (!StringUtils.isAbsoluteUrlString(href)) {
                    href = this.base + href;
                }
                return href;
            }
            return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
        }
    }

    public static class ImageSrc
    implements FicheItemFormatter {
        private final String base;

        public ImageSrc(String base) {
            this.base = base;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (!(ficheItem instanceof ImageItem)) {
                return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
            }
            String src = ((ImageItem)ficheItem).getSrc();
            if (!StringUtils.isAbsoluteUrlString(src)) {
                src = this.base + src;
            }
            return src;
        }
    }

    public static class ParaTransformation
    implements FicheItemFormatter {
        private final FicheBlockFormatter ficheBlockFormatter;

        public ParaTransformation(FicheBlockFormatter ficheBlockFormatter) {
            this.ficheBlockFormatter = ficheBlockFormatter;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (ficheItem instanceof ParaItem) {
                SubsetKey corpusKey = null;
                Subset currentSubset = formatSource.getSubsetItemPointeur().getSubset();
                if (currentSubset instanceof Corpus) {
                    corpusKey = currentSubset.getSubsetKey();
                }
                return this.ficheBlockFormatter.formatFicheBlocks(((ParaItem)ficheItem).toFicheBlocks(), formatSource, corpusKey);
            }
            return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
        }
    }

    public static class DatePattern
    implements FicheItemFormatter {
        private final DateTimeFormatter dateTimeFormatter;
        private final LangParameters langParameters;

        public DatePattern(DateTimeFormatter dateTimeFormatter, LangParameters langParameters) {
            this.dateTimeFormatter = dateTimeFormatter;
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (!(ficheItem instanceof DateItem)) {
                return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
            }
            LocalDate date = ((DateItem)ficheItem).toLocalDate();
            if (this.langParameters == null) {
                return date.format(this.dateTimeFormatter);
            }
            StringBuilder buf = new StringBuilder();
            Locale[] array = LangParameters.checkLocaleArray(this.langParameters, formatSource);
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                DateTimeFormatter locFormatter = this.dateTimeFormatter.withLocale(array[i]);
                buf.append(date.format(locFormatter));
            }
            return buf.toString();
        }
    }

    public static class DateLabel
    implements FicheItemFormatter {
        private final LangParameters langParameters;
        private final String truncateType;
        private final FormatStyle formatStyle;

        public DateLabel(LangParameters langParameters, String truncateType, FormatStyle formatStyle) {
            this.langParameters = langParameters;
            this.truncateType = truncateType;
            this.formatStyle = formatStyle;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (!(ficheItem instanceof DateItem)) {
                return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
            }
            DateItem dateItem = (DateItem)ficheItem;
            StringBuilder buf = new StringBuilder();
            FuzzyDate date = dateItem.getDate();
            if (!this.truncateType.equals("day")) {
                date = date.truncate(this.truncateType);
            }
            Locale[] array = LangParameters.checkLocaleArray(this.langParameters, formatSource);
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                this.appendLocale(buf, date, array[i]);
            }
            return buf.toString();
        }

        private void appendLocale(StringBuilder buf, FuzzyDate date, Locale locale) {
            FuzzyDateFormatter fuzzyDateFormatter = FuzzyDateFormatter.build(this.formatStyle, locale);
            buf.append(fuzzyDateFormatter.format(date));
        }
    }

    public static class AmountLabel
    implements FicheItemFormatter {
        private final LangParameters langParameters;
        private final boolean forceSubunit;

        public AmountLabel(LangParameters langParameters, boolean forceSubunit) {
            this.langParameters = langParameters;
            this.forceSubunit = forceSubunit;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (!(ficheItem instanceof AmountItem)) {
                return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
            }
            StringBuilder buf = new StringBuilder();
            AmountItem amountItem = (AmountItem)ficheItem;
            Decimal decimal = amountItem.getDecimal();
            long moneyLong = amountItem.toMoneyLong();
            ExtendedCurrency currency = amountItem.getCurrency();
            Locale[] array = LangParameters.checkLocaleArray(this.langParameters, formatSource);
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                this.appendLocale(buf, decimal, currency, moneyLong, array[i]);
            }
            return buf.toString();
        }

        private void appendLocale(StringBuilder buf, Decimal decimal, ExtendedCurrency currency, long moneyLong, Locale locale) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            String strg = this.forceSubunit ? MoneyUtils.toLitteralString(moneyLong, currency, symbols, false) : MoneyUtils.toLitteralString(decimal, currency, symbols);
            buf.append(strg);
        }
    }

    public static class NumberLabel
    implements FicheItemFormatter {
        private final LangParameters langParameters;

        public NumberLabel(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (!(ficheItem instanceof NumberItem)) {
                return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
            }
            Decimal decimal = ((NumberItem)ficheItem).getDecimal();
            StringBuilder buf = new StringBuilder();
            Locale[] array = LangParameters.checkLocaleArray(this.langParameters, formatSource);
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                this.appendLocale(buf, decimal, array[i]);
            }
            return buf.toString();
        }

        private void appendLocale(StringBuilder buf, Decimal decimal, Locale locale) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            buf.append(decimal.toString(symbols));
        }
    }

    public static class GeoLonLabel
    implements FicheItemFormatter {
        public final LangParameters langParameters;

        public GeoLonLabel(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            Lang[] langArray;
            if (!(ficheItem instanceof GeopointItem)) {
                return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
            }
            StringBuilder buf = new StringBuilder();
            DegreSexagesimal sexa = DegreSexagesimal.fromDegreDecimal(((GeopointItem)ficheItem).getLongitude());
            for (Lang lang : langArray = LangParameters.checkLangArray(this.langParameters, formatSource)) {
                if (buf.length() > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                MessageLocalisation messageLocalisation = formatSource.getMessageLocalisation(lang);
                String code = SpecialCodes.getLongitudeSpecialCode(sexa);
                buf.append(sexa.toString(false, " "));
                String message = messageLocalisation.toString(code);
                if (message != null) {
                    buf.append(message);
                    continue;
                }
                buf.append(code);
            }
            return buf.toString();
        }
    }

    public static class GeoLatLabel
    implements FicheItemFormatter {
        private final LangParameters langParameters;

        public GeoLatLabel(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            Lang[] langArray;
            if (!(ficheItem instanceof GeopointItem)) {
                return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
            }
            StringBuilder buf = new StringBuilder();
            DegreSexagesimal sexa = DegreSexagesimal.fromDegreDecimal(((GeopointItem)ficheItem).getLatitude());
            for (Lang lang : langArray = LangParameters.checkLangArray(this.langParameters, formatSource)) {
                if (buf.length() > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                MessageLocalisation messageLocalisation = formatSource.getMessageLocalisation(lang);
                String code = SpecialCodes.getLatitudeSpecialCode(sexa);
                buf.append(sexa.toString(false, " "));
                String message = messageLocalisation.toString(code);
                if (message != null) {
                    buf.append(message);
                    continue;
                }
                buf.append(code);
            }
            return buf.toString();
        }
    }

    public static class LanguageLabel
    implements FicheItemFormatter {
        private final LangParameters langParameters;

        public LanguageLabel(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            Lang[] langArray;
            if (!(ficheItem instanceof LanguageItem)) {
                return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
            }
            LanguageItem languageItem = (LanguageItem)ficheItem;
            String langCode = languageItem.getLang().toString();
            StringBuilder buf = new StringBuilder();
            for (Lang lang : langArray = LangParameters.checkLangArray(this.langParameters, formatSource)) {
                MessageLocalisation messageLocalisation = formatSource.getMessageLocalisation(lang);
                String message = messageLocalisation.toString(langCode);
                if (message == null) continue;
                message = StringUtils.getFirstPart(message);
                if (buf.length() > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                buf.append(message);
            }
            return buf.toString();
        }
    }

    public static class CountryLabel
    implements FicheItemFormatter {
        private final LangParameters langParameters;

        public CountryLabel(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            Lang[] langArray;
            if (!(ficheItem instanceof CountryItem)) {
                return FicheItemFormatterCatalog.getDefaultFormat(ficheItem);
            }
            CountryItem countryItem = (CountryItem)ficheItem;
            String countryCode = countryItem.getCountry().toString();
            StringBuilder buf = new StringBuilder();
            for (Lang lang : langArray = LangParameters.checkLangArray(this.langParameters, formatSource)) {
                MessageLocalisation messageLocalisation = formatSource.getMessageLocalisation(lang);
                String message = messageLocalisation.toString(countryCode);
                if (message == null) continue;
                message = StringUtils.getFirstPart(message);
                if (buf.length() > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                buf.append(message);
            }
            return buf.toString();
        }
    }

    public static class Json
    implements FicheItemFormatter {
        private final JsonParameters jsonParameters;
        private final LangContext customLangContext;

        public Json(JsonParameters jsonParameters, LangContext customLangContext) {
            this.jsonParameters = jsonParameters;
            this.customLangContext = customLangContext;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            JSONWriter jw = new JSONWriter(buf);
            try {
                jw.object();
                this.properties(jw, ficheItem, formatSource);
                jw.endObject();
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            return buf.toString();
        }

        private LangContext getLangContext(FormatSource formatSource) {
            if (this.customLangContext != null) {
                return this.customLangContext;
            }
            return formatSource.getLangContext();
        }

        private void properties(JSONWriter jw, FicheItem ficheItem, FormatSource formatSource) throws IOException {
            PropertyEligibility propertyEligibility = this.jsonParameters.getPropertyEligibility();
            LangContext langContext = this.getLangContext(formatSource);
            FichothequeQuestioner fichothequeQuestioner = formatSource.getFichothequeQuestioner();
            MessageLocalisationProvider messageLocalisationProvider = formatSource.getFormatContext().getMessageLocalisationProvider();
            if (ficheItem instanceof Item) {
                FicheItemJson.properties(jw, (Item)ficheItem, propertyEligibility);
            } else if (ficheItem instanceof DateItem) {
                FicheItemJson.properties(jw, (DateItem)ficheItem, propertyEligibility, langContext, this.getFormatStyle());
            } else if (ficheItem instanceof CountryItem) {
                FicheItemJson.properties(jw, (CountryItem)ficheItem, propertyEligibility, langContext, messageLocalisationProvider);
            } else if (ficheItem instanceof LanguageItem) {
                FicheItemJson.properties(jw, (LanguageItem)ficheItem, propertyEligibility, langContext, messageLocalisationProvider);
            } else if (ficheItem instanceof GeopointItem) {
                FicheItemJson.properties(jw, (GeopointItem)ficheItem, propertyEligibility, langContext, messageLocalisationProvider);
            } else if (ficheItem instanceof LinkItem) {
                FicheItemJson.properties(jw, (LinkItem)ficheItem, propertyEligibility);
            } else if (ficheItem instanceof ImageItem) {
                FicheItemJson.properties(jw, (ImageItem)ficheItem, propertyEligibility);
            } else if (ficheItem instanceof EmailItem) {
                FicheItemJson.properties(jw, (EmailItem)ficheItem, propertyEligibility);
            } else if (ficheItem instanceof NumberItem) {
                FicheItemJson.properties(jw, (NumberItem)ficheItem, propertyEligibility, langContext);
            } else if (ficheItem instanceof AmountItem) {
                FicheItemJson.properties(jw, (AmountItem)ficheItem, propertyEligibility, langContext);
            } else if (ficheItem instanceof ParaItem) {
                FicheItemJson.properties(jw, (ParaItem)ficheItem, propertyEligibility);
            } else if (ficheItem instanceof PersonItem) {
                FicheItemJson.properties(jw, (PersonItem)ficheItem, propertyEligibility, fichothequeQuestioner);
            }
            if (propertyEligibility.includeProperty("formsyntax")) {
                jw.key("formsyntax");
                jw.value(FormSyntax.toString(ficheItem, fichothequeQuestioner, null));
            }
        }

        private FormatStyle getFormatStyle() {
            FormatStyle formatStyle = this.jsonParameters.getFormatStyle();
            if (formatStyle == null) {
                return FormatStyle.LONG;
            }
            return formatStyle;
        }
    }
}

