/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.catalogs;

import java.io.IOException;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.syntax.FicheblockSyntax;
import net.fichotheque.tools.format.FicheBlockFormat;
import net.fichotheque.tools.format.ValuesParameters;

public final class FicheBlockFormatterCatalog {
    private static final FicheblockSyntax.Parameters DEFAULT_PARAMETERS = FicheblockSyntax.parameters().withSpecialParseChars(true);
    public static final FicheBlockFormatter FORMSYNTAX = (ficheBlocks, formatSource, defaultCorpusKey) -> FicheblockSyntax.toString(ficheBlocks, DEFAULT_PARAMETERS);
    public static final FicheBlockFormatter TEXT = (ficheBlocks, formatSource, defaultCorpusKey) -> {
        StringBuilder appendable = new StringBuilder();
        try {
            FicheBlockFormat.textFormat((Appendable)appendable, ficheBlocks, "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable.toString();
    };

    private FicheBlockFormatterCatalog() {
    }

    public static class Values
    implements FicheBlockFormatter {
        private final ValuesParameters valuesParameters;

        public Values(ValuesParameters valuesParameters) {
            this.valuesParameters = valuesParameters;
        }

        @Override
        public String formatFicheBlocks(FicheBlocks ficheBlocks, FormatSource formatSource, SubsetKey defaultCorpusKey) {
            int limit = this.valuesParameters.getLimit();
            int startIndex = this.valuesParameters.getStartIndex();
            String separator = this.valuesParameters.getSeparator();
            List<String> list = FicheBlockFormat.valuesFormat(ficheBlocks);
            int size = list.size();
            if (limit != -1) {
                size = Math.min(size, startIndex + limit);
            }
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            for (int i = startIndex; i < size; ++i) {
                if (first) {
                    first = false;
                } else {
                    buf.append(separator);
                }
                buf.append(list.get(i));
            }
            return buf.toString();
        }
    }
}

