/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.syntaxes;

import java.io.IOException;
import net.fichotheque.utils.SyntaxUtils;
import net.mapeadores.util.text.StringUtils;

public final class PathResolver {
    public static final int FILE = 1;
    public static final int DIR = 2;

    private PathResolver() {
    }

    public static String resolve(String value, int type) {
        if (value.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        try {
            PathResolver.resolve(buf, value, type);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static void resolve(Appendable appendable, String value, int type) throws IOException {
        String[] tokens = StringUtils.getTokens(value, '/', (short)0);
        int last = tokens.length - 1;
        boolean dirEnd = value.endsWith("/");
        for (int i = 0; i < last; ++i) {
            SyntaxUtils.appendSpan(appendable, "cm-path-dir", tokens[i]);
            SyntaxUtils.appendSpan(appendable, "cm-punctuation", "/");
        }
        if (type == -1) {
            type = dirEnd ? 2 : 1;
        }
        SyntaxUtils.appendSpan(appendable, PathResolver.getCssClass(type), tokens[last]);
        if (dirEnd) {
            SyntaxUtils.appendSpan(appendable, "cm-punctuation", "/");
        }
    }

    public static String getCssClass(int value) {
        switch (value) {
            case 1: {
                return "cm-path-file";
            }
            case 2: {
                return "cm-path-dir";
            }
        }
        return "";
    }
}

