/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.corpus;

import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.tools.extraction.corpus.CountryGroupEngine;
import net.fichotheque.tools.extraction.corpus.FieldsGroupEngine;
import net.fichotheque.tools.extraction.corpus.GroupEngine;
import net.fichotheque.tools.extraction.corpus.LangGroupEngine;
import net.fichotheque.tools.extraction.corpus.PositionGroupEngine;
import net.fichotheque.tools.extraction.corpus.TitleGroupEngine;
import net.fichotheque.tools.extraction.corpus.WeightGroupEngine;
import net.fichotheque.tools.extraction.corpus.YearGroupEngine;
import net.mapeadores.util.exceptions.SwitchException;

class GroupEngineProvider {
    private final GroupClause groupClause;
    private final GroupEngineProvider subProvider;

    GroupEngineProvider(GroupClause groupClause, GroupEngineProvider subProvider) {
        this.groupClause = groupClause;
        this.subProvider = subProvider;
    }

    GroupEngine newGroupEngine() {
        switch (this.groupClause.getGroupType()) {
            case "weight": {
                return new WeightGroupEngine(this.groupClause, this.subProvider);
            }
            case "title": {
                return new TitleGroupEngine(this.groupClause, this.subProvider);
            }
            case "year": {
                return new YearGroupEngine(this.groupClause, this.subProvider);
            }
            case "lang": {
                return new LangGroupEngine(this.groupClause, this.subProvider);
            }
            case "country": {
                return new CountryGroupEngine(this.groupClause, this.subProvider);
            }
            case "fields": {
                return new FieldsGroupEngine(this.groupClause, this.subProvider);
            }
            case "position": {
                return new PositionGroupEngine(this.groupClause, this.subProvider);
            }
        }
        throw new SwitchException("groupClause.getGroupeType() =  " + this.groupClause.getGroupType());
    }

    static GroupEngineProvider newInstance(GroupClause groupClause) {
        GroupClause subGroupClause = groupClause.getSubGroupClause();
        GroupEngineProvider subProvider = null;
        if (subGroupClause != null) {
            subProvider = GroupEngineProvider.newInstance(subGroupClause);
        }
        return new GroupEngineProvider(groupClause, subProvider);
    }
}

