/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.corpus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.run.FicheExtractInfo;
import net.fichotheque.extraction.run.FicheGroup;
import net.fichotheque.junction.Junction;
import net.fichotheque.tools.extraction.corpus.GroupBuilder;
import net.fichotheque.tools.extraction.corpus.GroupEngineProvider;
import net.fichotheque.tools.extraction.corpus.PositionGroupEngine;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.text.collation.group.CollationGroup;
import net.mapeadores.util.text.collation.group.CollationGroupBuilder;
import net.mapeadores.util.text.collation.group.ObjectWrapper;

public abstract class GroupEngine {
    GroupEngine() {
    }

    public static GroupEngine newInstance(GroupClause groupClause) {
        if (groupClause == null) {
            return new PositionGroupEngine(null, null);
        }
        GroupEngineProvider groupEngineProvider = GroupEngineProvider.newInstance(groupClause);
        return groupEngineProvider.newGroupEngine();
    }

    public abstract void add(FicheMeta var1, FicheFilter var2, Junction var3);

    public abstract FicheGroup[] toFicheGroupArray();

    public String getTagName(GroupClause groupClause) {
        TagNameInfo tagNameInfo = groupClause.getTagNameInfo();
        switch (tagNameInfo.getType()) {
            case 3: {
                return tagNameInfo.getCustomTagName();
            }
            case 2: {
                return null;
            }
        }
        return "group";
    }

    static FicheGroup[] toGroupArray(Collection<GroupBuilder> sortedCollection, GroupClause groupClause, GroupBuilder outsideCollectionGroupeBuilder) {
        FicheGroup[] result;
        int p;
        boolean asc = true;
        if (groupClause != null) {
            asc = groupClause.isAscendingOrder();
        }
        int size = sortedCollection.size();
        int n = p = asc ? 0 : size - 1;
        if (outsideCollectionGroupeBuilder != null) {
            result = new FicheGroup[size + 1];
            result[size] = outsideCollectionGroupeBuilder.toFicheGroup();
        } else {
            result = new FicheGroup[size];
        }
        for (GroupBuilder groupBuilder : sortedCollection) {
            result[p] = groupBuilder.toFicheGroup();
            if (asc) {
                ++p;
                continue;
            }
            --p;
        }
        return result;
    }

    static FicheGroup[] toGroupArray(CollationGroupBuilder collationGroupBuilder, GroupClause groupClause, GroupEngineProvider subEngineProvider) {
        boolean asc = groupClause.isAscendingOrder();
        List<CollationGroup> list = collationGroupBuilder.getCollationGroupList();
        int size = list.size();
        ArrayList<GroupBuilder> groupBuilderList = new ArrayList<GroupBuilder>();
        for (int i = 0; i < size; ++i) {
            CollationGroup collationGroup = list.get(i);
            char[] array = new char[]{collationGroup.getInitial()};
            String name = new String(array);
            HashMap<String, String> attributesMap = new HashMap<String, String>();
            int byInteger = GroupEngine.getByInteger(array[0]);
            attributesMap.put("order", String.valueOf(byInteger));
            GroupBuilder groupBuilder = GroupBuilder.newInstance(name, groupClause.getTagNameInfo(), subEngineProvider);
            groupBuilder.setAttributesMap(attributesMap);
            List<ObjectWrapper> wrapperList = collationGroup.getSortedObjectWrapperList();
            int wrapperLength = wrapperList.size();
            for (int j = 0; j < wrapperLength; ++j) {
                int index = asc ? j : size - j - 1;
                ObjectWrapper wrapper = wrapperList.get(index);
                FicheExtractInfo ficheExtractInfo = (FicheExtractInfo)wrapper.getObject();
                groupBuilder.add(ficheExtractInfo);
            }
            groupBuilderList.add(groupBuilder);
        }
        return GroupEngine.toGroupArray(groupBuilderList, groupClause, null);
    }

    private static int getByInteger(char c) {
        if (c == '?') {
            return 10;
        }
        if (c == '_') {
            return 37;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 54;
        }
        throw new SwitchException("char = " + c);
    }
}

