/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.builders;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.filterunit.BodyFilterUnit;
import net.fichotheque.extraction.filterunit.FieldKeyFilterUnit;
import net.fichotheque.extraction.filterunit.FieldNamePrefixFilterUnit;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.utils.ExtractionUtils;

public class FicheFilterBuilder {
    private final List<FilterUnit> filterUnitList = new ArrayList<FilterUnit>();
    private TagNameInfo tagNameInfo = TagNameInfo.DEFAULT;

    public FicheFilterBuilder add(FilterUnit filterUnit) {
        if (filterUnit == null) {
            throw new NullPointerException("filterUnit is null");
        }
        this.filterUnitList.add(filterUnit);
        return this;
    }

    public FicheFilterBuilder setTagNameInfo(TagNameInfo tagNameInfo) {
        this.tagNameInfo = tagNameInfo;
        return this;
    }

    private boolean testCorpsdefiche(short category) {
        switch (category) {
            case 3: {
                return true;
            }
        }
        return false;
    }

    public FicheFilter toFicheFilter() {
        boolean withCorpsdefiche = false;
        int cellMax = -1;
        for (FilterUnit filterUnit : this.filterUnitList) {
            int cellValue;
            boolean test;
            if (filterUnit instanceof BodyFilterUnit) {
                withCorpsdefiche = true;
            } else if (filterUnit instanceof FieldKeyFilterUnit) {
                test = this.testCorpsdefiche(((FieldKeyFilterUnit)filterUnit).getFieldKey().getCategory());
                if (test) {
                    withCorpsdefiche = true;
                }
            } else if (filterUnit instanceof FieldNamePrefixFilterUnit && (test = this.testCorpsdefiche(((FieldNamePrefixFilterUnit)filterUnit).getCategory()))) {
                withCorpsdefiche = true;
            }
            if ((cellValue = filterUnit.getParameters().getIntValue("cell-order")) <= 0) continue;
            cellMax = Math.max(cellMax, cellValue);
        }
        List<FilterUnit> finalFilterUnitList = ExtractionUtils.toImmutableList(this.filterUnitList);
        return new InternalFicheFilter(this.tagNameInfo, finalFilterUnitList, withCorpsdefiche, cellMax);
    }

    public static FicheFilterBuilder init() {
        return new FicheFilterBuilder();
    }

    private static class InternalFicheFilter
    implements FicheFilter {
        private final TagNameInfo tagNameInfo;
        private final List<FilterUnit> filterUnitList;
        private final boolean withCorpsdefiche;
        private final int cellMax;

        private InternalFicheFilter(TagNameInfo tagNameInfo, List<FilterUnit> filterUnitList, boolean withCorpsdefiche, int cellMax) {
            this.tagNameInfo = tagNameInfo;
            this.filterUnitList = filterUnitList;
            this.withCorpsdefiche = withCorpsdefiche;
            this.cellMax = cellMax;
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.tagNameInfo;
        }

        @Override
        public boolean isWithCorpsdefiche() {
            return this.withCorpsdefiche;
        }

        @Override
        public List<FilterUnit> getFilterUnitList() {
            return this.filterUnitList;
        }

        @Override
        public int getCellMax() {
            return this.cellMax;
        }
    }
}

