/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.builders;

import java.util.function.Predicate;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.IrefConverter;
import net.fichotheque.tools.extraction.IrefConverterFactory;

public class ExtractParametersBuilder {
    private final ExtractionContext extractionContext;
    private final int extractVersion;
    private boolean withEmpty = false;
    private boolean withPosition = false;
    private Predicate<FicheMeta> fichePredicate = null;
    private IrefConverterFactory irefConverterFactory = null;

    public ExtractParametersBuilder(ExtractionContext extractionContext, int extractVersion) {
        this.extractionContext = extractionContext;
        this.extractVersion = extractVersion;
    }

    public ExtractParametersBuilder setWithEmpty(boolean withEmpty) {
        this.withEmpty = withEmpty;
        return this;
    }

    public ExtractParametersBuilder setWithPosition(boolean withPosition) {
        this.withPosition = withPosition;
        return this;
    }

    public ExtractParametersBuilder setFichePredicate(Predicate<FicheMeta> fichePredicate) {
        this.fichePredicate = fichePredicate;
        return this;
    }

    public ExtractParameters toExtractParameters() {
        if (this.irefConverterFactory == null) {
            this.irefConverterFactory = new IrefConverterFactory();
        }
        return new InternalExtractParameters(this.extractionContext, this.extractVersion, this.withEmpty, this.fichePredicate, this.irefConverterFactory, this.withPosition);
    }

    public static ExtractParametersBuilder init(ExtractionContext extractionContext, int extractVersion) {
        return new ExtractParametersBuilder(extractionContext, extractVersion);
    }

    private static class InternalExtractParameters
    implements ExtractParameters {
        private final ExtractionContext extractionContext;
        private final int extractVersion;
        private final boolean withEmpty;
        private final Predicate<FicheMeta> fichePredicate;
        private final IrefConverterFactory irefConverterFactory;
        private final boolean withPosition;

        private InternalExtractParameters(ExtractionContext extractionContext, int extractVersion, boolean withEmpty, Predicate<FicheMeta> fichePredicate, IrefConverterFactory irefConverterFactory, boolean withPosition) {
            this.extractionContext = extractionContext;
            this.extractVersion = extractVersion;
            this.withEmpty = withEmpty;
            this.fichePredicate = fichePredicate;
            this.irefConverterFactory = irefConverterFactory;
            this.withPosition = withPosition;
        }

        @Override
        public ExtractionContext getExtractionContext() {
            return this.extractionContext;
        }

        @Override
        public int getExtractVersion() {
            return this.extractVersion;
        }

        @Override
        public boolean isWithEmpty() {
            return this.withEmpty;
        }

        @Override
        public Predicate<FicheMeta> getFichePredicate() {
            return this.fichePredicate;
        }

        @Override
        public IrefConverter newIrefConverter() {
            return this.irefConverterFactory.newInstance();
        }

        @Override
        public boolean isWithPosition() {
            return this.withPosition;
        }
    }
}

