/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.externalsource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.fichotheque.externalsource.ExternalSourceDef;

public class ExternalSourceDefBuilder {
    private final String type;
    private final Map<String, String> paramMap = new LinkedHashMap<String, String>();

    public ExternalSourceDefBuilder(String type) {
        this.type = type;
    }

    public ExternalSourceDefBuilder addParam(String name, String value) {
        if (value == null) {
            this.paramMap.remove(name);
        } else {
            this.paramMap.put(name, value);
        }
        return this;
    }

    public ExternalSourceDef toExternalSourceDef() {
        LinkedHashMap<String, String> finalParamMap = new LinkedHashMap<String, String>(this.paramMap);
        return new InternalExternalSourceDef(this.type, finalParamMap);
    }

    public static ExternalSourceDefBuilder init(String type) {
        return new ExternalSourceDefBuilder(type);
    }

    private static class InternalExternalSourceDef
    implements ExternalSourceDef {
        private final String type;
        private final Map<String, String> paramMap;

        private InternalExternalSourceDef(String type, Map<String, String> paramMap) {
            this.type = type;
            this.paramMap = paramMap;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public Set<String> getParamNameSet() {
            return Collections.unmodifiableSet(this.paramMap.keySet());
        }

        @Override
        public String getParam(String name) {
            return this.paramMap.get(name);
        }
    }
}

