/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.transformation;

import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationDescription;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.utils.TransformationUtils;

public class TransformationDescriptionBuilder {
    private final TransformationKey transformationKey;
    private final SortedMap<String, TemplateDescription> simpleMap = new TreeMap<String, TemplateDescription>();
    private final SortedMap<String, TemplateDescription> streamMap = new TreeMap<String, TemplateDescription>();

    public TransformationDescriptionBuilder(TransformationKey transformationKey) {
        this.transformationKey = transformationKey;
    }

    public TransformationDescriptionBuilder addTemplateDescription(TemplateDescription templateDescription) {
        TemplateKey templateKey = templateDescription.getTemplateKey();
        String extension = templateKey.getExtension();
        if (extension == null) {
            this.simpleMap.put(templateKey.getName(), templateDescription);
        } else {
            String key = extension + "/" + templateKey.getName();
            this.streamMap.put(key, templateDescription);
        }
        return this;
    }

    public TransformationDescriptionBuilder addTemplateDescriptions(Collection<TemplateDescription> templateDescriptions) {
        for (TemplateDescription templateDescription : templateDescriptions) {
            if (templateDescription == null) continue;
            this.addTemplateDescription(templateDescription);
        }
        return this;
    }

    public TransformationDescription toTransformationDescription() {
        List<TemplateDescription> simpleArray = TransformationUtils.wrap(this.simpleMap.values().toArray(new TemplateDescription[this.simpleMap.size()]));
        List<TemplateDescription> streamArray = TransformationUtils.wrap(this.streamMap.values().toArray(new TemplateDescription[this.streamMap.size()]));
        return new InternalTransformationDescription(this.transformationKey, simpleArray, streamArray);
    }

    public static TransformationDescriptionBuilder init(TransformationKey transformationKey) {
        return new TransformationDescriptionBuilder(transformationKey);
    }

    private static class InternalTransformationDescription
    implements TransformationDescription {
        private final TransformationKey transformationKey;
        private final List<TemplateDescription> simpleList;
        private final List<TemplateDescription> streamList;

        private InternalTransformationDescription(TransformationKey transformationKey, List<TemplateDescription> simpleList, List<TemplateDescription> streamList) {
            this.transformationKey = transformationKey;
            this.simpleList = simpleList;
            this.streamList = streamList;
        }

        @Override
        public TransformationKey getTransformationKey() {
            return this.transformationKey;
        }

        @Override
        public List<TemplateDescription> getSimpleTemplateDescriptionList() {
            return this.simpleList;
        }

        @Override
        public List<TemplateDescription> getStreamTemplateDescriptionList() {
            return this.streamList;
        }
    }
}

