/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.transformation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TransformationDescription;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.utils.TransformationUtils;
import net.mapeadores.util.annotation.Nullable;

public class TransformationCheck {
    private final TransformationDescription transformationDescription;
    private TemplateDescription[] simpleTemplateDescriptionArray;
    private String[] extensionArray;
    private SortedMap<String, TemplateDescription[]> extensionMap;

    private TransformationCheck(TransformationDescription transformationDescription) {
        this.transformationDescription = transformationDescription;
    }

    public TransformationKey getTransformationKey() {
        return this.transformationDescription.getTransformationKey();
    }

    public TransformationDescription getTransformationDescription() {
        return this.transformationDescription;
    }

    public boolean withTemplate() {
        return this.withSimpleTemplate() || this.withStreamTemplate();
    }

    public boolean withSimpleTemplate() {
        return this.simpleTemplateDescriptionArray != null;
    }

    public boolean withStreamTemplate() {
        return this.extensionArray.length != 0;
    }

    @Nullable
    public TemplateDescription[] getSimpleTemplateDescriptionArray() {
        return this.simpleTemplateDescriptionArray;
    }

    public String[] getExtensionArray() {
        return this.extensionArray;
    }

    @Nullable
    public TemplateDescription[] getStreamTemplateDescriptionArray(String extension) {
        return (TemplateDescription[])this.extensionMap.get(extension);
    }

    private void init(boolean onlyUseableTemplate) {
        TreeMap<String, TemplateDescription> simpleMap = new TreeMap<String, TemplateDescription>();
        for (TemplateDescription templateDescription : this.transformationDescription.getSimpleTemplateDescriptionList()) {
            if (onlyUseableTemplate && !TransformationUtils.isUseableTemplateState(templateDescription.getState())) continue;
            simpleMap.put(templateDescription.getTemplateKey().getName(), templateDescription);
        }
        int simpleSize = simpleMap.size();
        this.simpleTemplateDescriptionArray = simpleSize == 0 ? null : simpleMap.values().toArray(new TemplateDescription[simpleSize]);
        TreeMap<String, ArrayList<TemplateDescription>> tempMap = new TreeMap<String, ArrayList<TemplateDescription>>();
        for (TemplateDescription templateDescription : this.transformationDescription.getStreamTemplateDescriptionList()) {
            if (onlyUseableTemplate && !TransformationUtils.isUseableTemplateState(templateDescription.getState())) continue;
            String extension = templateDescription.getTemplateKey().getExtension();
            ArrayList<TemplateDescription> list = (ArrayList<TemplateDescription>)tempMap.get(extension);
            if (list == null) {
                list = new ArrayList<TemplateDescription>();
                tempMap.put(extension, list);
            }
            list.add(templateDescription);
        }
        this.extensionArray = tempMap.keySet().toArray(new String[tempMap.size()]);
        this.extensionMap = new TreeMap<String, TemplateDescription[]>();
        for (Map.Entry entry : tempMap.entrySet()) {
            List list = (List)entry.getValue();
            TemplateDescription[] array = list.toArray(new TemplateDescription[list.size()]);
            this.extensionMap.put((String)entry.getKey(), array);
        }
    }

    public static TransformationCheck check(TransformationDescription transformationDescription, boolean onlyUseableTemplate) {
        TransformationCheck transformationCheck = new TransformationCheck(transformationDescription);
        transformationCheck.init(onlyUseableTemplate);
        return transformationCheck;
    }
}

